/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqvbox.h>
#include <tqlayout.h>
#include <tqwidget.h>
#include <tqwhatsthis.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tqcombobox.h>
#include <tqcheckbox.h>

// Include files for KDE

#include <tdelocale.h>
#include <knuminput.h>

// Local includes

#include "convertoptionsdialog.h"
#include "convertoptionsdialog.moc"

namespace KIPIBatchProcessImagesPlugin
{

ConvertOptionsDialog::ConvertOptionsDialog(TQWidget *parent, int ImageFormatType)
                        : KDialogBase( parent, "ConvertOptionsDialog", true,
                          i18n("Image File Format Options"), Ok|Cancel, Ok, false)
{
    TQWidget* box = new TQWidget( this );
    setMainWidget(box);
    TQVBoxLayout *dvlay = new TQVBoxLayout( box, 10, spacingHint() );
    TQString whatsThis;

    if (ImageFormatType == 0 || ImageFormatType == 1) // JPEG || PNG
       {
       m_label_imageCompression = new TQLabel (i18n("Image compression level:"), box);
       dvlay->addWidget( m_label_imageCompression );
       m_JPEGPNGCompression = new KIntNumInput(75, box);
       m_JPEGPNGCompression->setRange(1, 100, 1, true );
       whatsThis = i18n("<p>The compression value for the target images:<p>");
       whatsThis = whatsThis + i18n("<b>1</b>: very high compression<p>"
                                    "<b>25</b>: high compression<p>"
                                    "<b>50</b>: medium compression<p>"
                                    "<b>75</b>: low compression (default value)<p>"
                                    "<b>100</b>: no compression");

       TQWhatsThis::add( m_JPEGPNGCompression, whatsThis);
       m_label_imageCompression->setBuddy( m_JPEGPNGCompression );
       dvlay->addWidget( m_JPEGPNGCompression );

       if (ImageFormatType == 0) // JPEG
          {
          m_compressLossLess = new TQCheckBox( i18n("Use lossless compression"), box);
          TQWhatsThis::add( m_compressLossLess, i18n("<p>If this option is enabled, "
                                                    "all JPEG operations will use a lossless compression."));
          dvlay->addWidget( m_compressLossLess );

          connect(m_compressLossLess, TQT_SIGNAL( toggled(bool) ), this, TQT_SLOT( slotCompressLossLessEnabled(bool) ) );
          }
       }

    if (ImageFormatType == 2) // TIFF
       {
       TQLabel *m_label_imageCompression = new TQLabel (i18n("Image compression algorithm:"), box);
       dvlay->addWidget( m_label_imageCompression );
       m_TIFFCompressionAlgo = new TQComboBox( false, box );
       m_TIFFCompressionAlgo->insertItem("LZW");
       m_TIFFCompressionAlgo->insertItem("JPEG");
       m_TIFFCompressionAlgo->insertItem(i18n("None"));
       TQWhatsThis::add( m_TIFFCompressionAlgo, i18n("<p>Select here the compression algorithm.") );
       m_label_imageCompression->setBuddy( m_TIFFCompressionAlgo );
       dvlay->addWidget( m_TIFFCompressionAlgo );
       }

    if (ImageFormatType == 5) // TGA
       {
       TQLabel *m_label_imageCompression = new TQLabel (i18n("Image compression algorithm:"), box);
       dvlay->addWidget( m_label_imageCompression );
       m_TGACompressionAlgo = new TQComboBox( false, box );
       m_TGACompressionAlgo->insertItem("RLE");
       m_TGACompressionAlgo->insertItem(i18n("None"));
       TQWhatsThis::add( m_TGACompressionAlgo, i18n("<p>Select here the compression algorithm.") );
       m_label_imageCompression->setBuddy( m_TGACompressionAlgo );
       dvlay->addWidget( m_TGACompressionAlgo );
       }
}

ConvertOptionsDialog::~ConvertOptionsDialog()
{
}

void ConvertOptionsDialog::slotCompressLossLessEnabled(bool val)
{
    m_JPEGPNGCompression->setEnabled( !val );
    m_label_imageCompression->setEnabled( !val );
}

}  // NameSpace KIPIBatchProcessImagesPlugin
