/* ============================================================
 *
 * This file is a part of kipi-plugins project
 * http://www.kipi-plugins.org
 *
 * Date        : 2004-10-01
 * Description : a kipi plugin to batch process images
 *
 * Copyright (C) 2004-2007 by Gilles Caulier <caulier dot gilles at gmail dot com>
 *
 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published by the Free Software Foundation;
 * either version 2, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * ============================================================ */

// Include files for TQt

#include <tqvbox.h>
#include <tqlayout.h>
#include <tqwidget.h>
#include <tqwhatsthis.h>
#include <tqlabel.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <tqstring.h>
#include <tqcombobox.h>
#include <tqcolor.h>

// Include files for KDE

#include <tdelocale.h>
#include <knuminput.h>
#include <kcolorbutton.h>

// Local includes

#include "borderoptionsdialog.h"
#include "borderoptionsdialog.moc"

namespace KIPIBatchProcessImagesPlugin
{

BorderOptionsDialog::BorderOptionsDialog(TQWidget *parent, int BorderType)
                        : KDialogBase( parent, "BorderOptionsDialog", true,
                          i18n("Border Options"), Ok|Cancel, Ok, false)
{
    TQWidget* box = new TQWidget( this );
    setMainWidget(box);
    TQVBoxLayout *dvlay = new TQVBoxLayout( box, 10, spacingHint() );
    TQString whatsThis;

    if (BorderType == 0) // Solid
       {
       TQLabel *m_label_solidBorderWidth = new TQLabel (i18n("Border width:"), box);
       dvlay->addWidget( m_label_solidBorderWidth );
       m_solidBorderWidth = new KIntNumInput(25, box);
       m_solidBorderWidth->setRange(1, 1000, 1, true );
       TQWhatsThis::add( m_solidBorderWidth, i18n("<p>Select here the border width in pixels.") );
       m_label_solidBorderWidth->setBuddy( m_solidBorderWidth );
       dvlay->addWidget( m_solidBorderWidth );

       TQLabel *m_label_solidColor = new TQLabel(i18n("Border color:"), box);
       dvlay->addWidget( m_label_solidColor );
       TQColor solidBorderColor = TQColor( 0, 0, 0 );                         // Black per default.
       m_button_solidBorderColor = new KColorButton( solidBorderColor, box );
       TQWhatsThis::add( m_button_solidBorderColor, i18n( "<p>You can select here the border color." ));
       dvlay->addWidget( m_button_solidBorderColor );
       }

    if (BorderType == 1) // Niepce
       {
       TQLabel *m_label_lineNiepceBorderWidth = new TQLabel (i18n("Line border width:"), box);
       dvlay->addWidget( m_label_lineNiepceBorderWidth );
       m_lineNiepceBorderWidth = new KIntNumInput(10, box);
       m_lineNiepceBorderWidth->setRange(1, 500, 1, true );
       TQWhatsThis::add( m_lineNiepceBorderWidth, i18n("<p>Select here the line border width in pixels.") );
       m_label_lineNiepceBorderWidth->setBuddy( m_lineNiepceBorderWidth );
       dvlay->addWidget( m_lineNiepceBorderWidth );

       TQLabel *m_label_lineNiepceColor = new TQLabel(i18n("Line border color:"), box);
       dvlay->addWidget( m_label_lineNiepceColor );
       TQColor lineNiepceBorderColor = TQColor( 0, 0, 0 );                         // Black per default.
       m_button_lineNiepceBorderColor = new KColorButton( lineNiepceBorderColor, box );
       TQWhatsThis::add( m_button_lineNiepceBorderColor, i18n( "<p>You can select here the line border color." ));
       dvlay->addWidget( m_button_lineNiepceBorderColor );

       TQLabel *m_label_NiepceBorderWidth = new TQLabel (i18n("Border width:"), box);
       dvlay->addWidget( m_label_NiepceBorderWidth );
       m_NiepceBorderWidth = new KIntNumInput(100, box);
       m_NiepceBorderWidth->setRange(1, 500, 1, true );
       TQWhatsThis::add( m_NiepceBorderWidth, i18n("<p>Select here the border width in pixels.") );
       m_label_NiepceBorderWidth->setBuddy( m_NiepceBorderWidth );
       dvlay->addWidget( m_NiepceBorderWidth );

       TQLabel *m_label_NiepceColor = new TQLabel(i18n("Border color:"), box);
       dvlay->addWidget( m_label_NiepceColor );
       TQColor NiepceBorderColor = TQColor( 255, 255, 255 );                         // White per default.
       m_button_NiepceBorderColor = new KColorButton( NiepceBorderColor, box );
       TQWhatsThis::add( m_button_NiepceBorderColor, i18n( "<p>You can select here the border color." ));
       dvlay->addWidget( m_button_NiepceBorderColor );
       }

    if (BorderType == 2) // Raise
       {
       TQLabel *m_label_raiseBorderWidth = new TQLabel (i18n("Border width:"), box);
       dvlay->addWidget( m_label_raiseBorderWidth );
       m_raiseBorderWidth = new KIntNumInput(50, box);
       m_raiseBorderWidth->setRange(1, 500, 1, true );
       TQWhatsThis::add( m_raiseBorderWidth, i18n("<p>Select here the border width in pixels.") );
       m_label_raiseBorderWidth->setBuddy( m_raiseBorderWidth );
       dvlay->addWidget( m_raiseBorderWidth );
       }

    if (BorderType == 3) // Frame
       {
       TQLabel *m_label_frameBorderWidth = new TQLabel (i18n("Border width:"), box);
       dvlay->addWidget( m_label_frameBorderWidth );
       m_frameBorderWidth = new KIntNumInput(25, box);
       m_frameBorderWidth->setRange(0, 500, 1, true );
       TQWhatsThis::add( m_frameBorderWidth, i18n("<p>Select here the border width in pixels.") );
       m_label_frameBorderWidth->setBuddy( m_frameBorderWidth );
       dvlay->addWidget( m_frameBorderWidth );

       TQLabel *m_label_frameBevelBorderWidth = new TQLabel (i18n("Bevel width:"), box);
       dvlay->addWidget( m_label_frameBevelBorderWidth );
       m_frameBevelBorderWidth = new KIntNumInput(10, box);
       m_frameBevelBorderWidth->setRange(0, 250, 1, true );
       TQWhatsThis::add( m_frameBevelBorderWidth, i18n("<p>Select here the bevel width in pixels. "
                                                      "This value must be <= Border width / 2") );
       m_label_frameBevelBorderWidth->setBuddy( m_frameBevelBorderWidth );
       dvlay->addWidget( m_frameBevelBorderWidth );

       TQLabel *m_label_frameColor = new TQLabel(i18n("Border color:"), box);
       dvlay->addWidget( m_label_frameColor );
       TQColor frameBorderColor = TQColor( 0, 0, 0 );                         // Black per default.
       m_button_frameBorderColor = new KColorButton( frameBorderColor, box );
       TQWhatsThis::add( m_button_frameBorderColor, i18n( "<p>You can select here the border color." ));
       dvlay->addWidget( m_button_frameBorderColor );

       connect(m_frameBorderWidth, TQT_SIGNAL(valueChanged(int)), this, TQT_SLOT(slotFrameBorderWidthChanged(int)));
       }
}

BorderOptionsDialog::~BorderOptionsDialog()
{
}

void BorderOptionsDialog::slotFrameBorderWidthChanged (int value)
{
   m_frameBevelBorderWidth->setMaxValue((int)(value / 2));
}

}  // NameSpace KIPIBatchProcessImagesPlugin
