/***************************************************************************
  begin                : Fri Nov 1 2002
  copyright            : (C) 2002 by Christian Hubinger
  email                : chubinger@irrsinnig.org
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "kmfruleeditorprotocol.h"

// kde includes
#include <kdebug.h>
#include <tdelocale.h>
#include <tdemessagebox.h>
#include <tdeapplication.h>

// qt includes
#include <tqlayout.h>
#include <tqcheckbox.h>
#include <tqtabwidget.h>
#include <tqstring.h>
#include <tqcombobox.h>
#include <tqspinbox.h>
#include <tqgroupbox.h>

// project includes
#include "../../core/xmlnames.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptrule.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"
#include "../../core/xmlnames.h"
#include "../../kmfwidgets/kmfportwidget.h"
#include "../../kmfwidgets/kmfmultiportwidget.h"
namespace KMF {
KMFRuleEditorProtocol::KMFRuleEditorProtocol( TQWidget *parent, const char *name, WFlags fl ) : KMyFirewallRuleEditorProtocol( parent, name, fl ) {
	use_multiport = false;
	cb_icmp_type->insertItem( "echo-request" );
	cb_icmp_type->insertItem( "echo-reply" );
	cb_icmp_type->insertItem( "source-quench" );
	cb_icmp_type->insertItem( "router-advertisement" );
	cb_icmp_type->insertItem( "router-solicitation" );
	cb_icmp_type->insertItem( "timestamp-request" );
	cb_icmp_type->insertItem( "timestamp-reply" );
	cb_icmp_type->insertItem( "address-mask-request" );
	cb_icmp_type->insertItem( "address-mask-reply" );
	cb_icmp_type->insertItem( "destination-unreachable" );
	cb_icmp_type->insertItem( "network-unreachable" );
	cb_icmp_type->insertItem( "host-unreachable" );
	cb_icmp_type->insertItem( "protocol-unreachable" );
	cb_icmp_type->insertItem( "port-unreachable" );
	cb_icmp_type->insertItem( "fragmentation-needed" );
	cb_icmp_type->insertItem( "source-route-failed" );
	cb_icmp_type->insertItem( "network-unknown" );
	cb_icmp_type->insertItem( "host-unknown" );
	cb_icmp_type->insertItem( "network-prohibited" );
	cb_icmp_type->insertItem( "host-prohibited" );
	cb_icmp_type->insertItem( "TOS-network-unreachable" );
	cb_icmp_type->insertItem( "TOS-host-unreachable" );
	cb_icmp_type->insertItem( "communication-prohibited" );
	cb_icmp_type->insertItem( "host-precedence-violation" );
	cb_icmp_type->insertItem( "precedence-cutoff" );
	cb_icmp_type->insertItem( "redirect" );
	cb_icmp_type->insertItem( "network-redirect" );
	cb_icmp_type->insertItem( "host-redirect" );
	cb_icmp_type->insertItem( "TOS-network-redirect" );
	cb_icmp_type->insertItem( "TOS-host-redirect" );
	cb_icmp_type->insertItem( "time-exceeded" );
	cb_icmp_type->insertItem( "ttl-zero-during-transit" );
	cb_icmp_type->insertItem( "ttl-zero-during-reassembly" );
	cb_icmp_type->insertItem( "parameter-problem" );
	cb_icmp_type->insertItem( "ip-header-bad" );
	cb_icmp_type->insertItem( "required-option-missing" );

	mpwid = new KMFMultiPortWidget( tab_multiport, "mpwid" );
	connect( mpwid, TQT_SIGNAL( sigMultiPortChanged( bool ) ), this, TQT_SLOT( toggleMultiPort( bool ) ) );

	pw_dest_port = new KMFPortWidget( tab_ports, "pw_dest_port" );
	pw_dest_port->setEnabled( false );
	connect( c_dest_port, TQT_SIGNAL( toggled( bool ) ) , pw_dest_port, TQT_SLOT( setEnabled( bool ) ) );

	pw_src_port = new KMFPortWidget( tab_ports, "pw_src_port" );
	pw_src_port->setEnabled( false );
	connect( c_src_port, TQT_SIGNAL( toggled( bool ) ) , pw_src_port, TQT_SLOT( setEnabled( bool ) ) );

	tab_multiportLayout->addMultiCellWidget( mpwid, 0, 0, 2, 2 );
	tab_portsLayout->addWidget( pw_src_port, 1, 1 );
	tab_portsLayout->addWidget( pw_dest_port, 2, 1 );

	connect( c_udp, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( toggleUdpRule( bool ) ) );
	connect( c_icmp, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( toggleIcmpRule( bool ) ) );
	connect( c_tcp, TQT_SIGNAL( toggled( bool ) ), this, TQT_SLOT( toggleTcpRule( bool ) ) );
	tabWidget->setTabEnabled( tab_ports, false );
	tabWidget->setTabEnabled( tab_multiport, false );
	tabWidget->setTabEnabled( tab_icmp, false );
	tabWidget->setTabEnabled( tab_special_tcp, false );

	tabWidget->setEnabled( false );
	adjustSize();
}

KMFRuleEditorProtocol::~KMFRuleEditorProtocol() {}

bool KMFRuleEditorProtocol::multiportEnabled() const {
	return use_multiport;
}

int KMFRuleEditorProtocol::getItemNum( const TQString& option ) {
	kdDebug() << "int KMFRuleEditorTos::getItemNum(const TQString& option)" << endl;
	int index = -1;
	for ( int i = 0; i < cb_icmp_type->count(); i++ ) {
		TQString tmp_item = cb_icmp_type->text( i );
		if ( tmp_item == option ) {
			index = i;
		}
	}
	return index;
}

void KMFRuleEditorProtocol::toggleMultiPort( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleMultiPort(" << enabled << ")" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_ports, false );
		if ( c_tcp->isChecked() )
			tabWidget->setTabEnabled( tab_special_tcp, false );

		use_multiport = true;
	} else {
		tabWidget->setTabEnabled( tab_ports, true );
		if ( c_tcp->isChecked() )
			tabWidget->setTabEnabled( tab_special_tcp, true );

		use_multiport = false;
	}
}

void KMFRuleEditorProtocol::toggleUdpRule( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleMultiPort(bool)" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_ports, true );
		tabWidget->setTabEnabled( tab_multiport, true );
		tabWidget->setTabEnabled( tab_icmp, false );
		tabWidget->setTabEnabled( tab_special_tcp, false );
	} else {
		//    tabWidget->setTabEnabled(tab_ports,true);
		//		tabWidget->setTabEnabled(tab_multi_port,true);
		//		tabWidget->setTabEnabled(tab_special_tcp,true);
	}
}
void KMFRuleEditorProtocol::toggleTcpRule( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleTcpRule(bool)" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_ports, true );
		tabWidget->setTabEnabled( tab_multiport, true );
		tabWidget->setTabEnabled( tab_special_tcp, true );
		tabWidget->setTabEnabled( tab_icmp, false );
	} else {
		//		tabWidget->setTabEnabled(tab_icmp,true);
	}
}

void KMFRuleEditorProtocol::toggleIcmpRule( bool enabled ) {
	kdDebug() << "void KMFRuleEditorProtocol::toggleIcmpRule(bool)" << endl;
	if ( enabled ) {
		tabWidget->setTabEnabled( tab_icmp, true );
		tabWidget->setTabEnabled( tab_special_tcp, false );
		tabWidget->setTabEnabled( tab_ports, false );
		tabWidget->setTabEnabled( tab_multiport, false );
	} else {
		//		tabWidget->setTabEnabled(tab_special_tcp,true);
		//		tabWidget->setTabEnabled(tab_ports,true);
		//    tabWidget->setTabEnabled(tab_multiport,false);
	}
}

void KMFRuleEditorProtocol::loadRule( IPTRule* rule ) {
	kdDebug() << "void KMFRuleEditorProtocol::loadRule(IPTRule* rule)" << endl;
	m_rule = rule;
	toggleMultiPort( false );
	toggleTcpRule( false );
	pw_dest_port->reset();
	pw_dest_port->reset();
	mpwid->reset();
	c_all->setChecked( false );
	c_icmp->setChecked( false );
	c_udp->setChecked( false );
	c_tcp->setChecked( false );
	c_src_port->setChecked( false );
	c_dest_port->setChecked( false );
	c_icmp_type->setChecked( false );
	c_inv_icmp->setChecked( false );
	c_inv_prot->setChecked( false );
	cb_icmp_type->setCurrentItem( 0 );
	c_tcp_flags->setChecked( false );
	c_inv_flags->setChecked( false );
	c_tcp_option->setChecked( false );
	c_inv_tcp_option->setChecked( false );
	sb_tcp_option_num->setValue( 0 );
	c_all_mask->setChecked( false );
	c_none_mask->setChecked( false );
	c_syn_mask->setChecked( false );
	c_ack_mask->setChecked( false );
	c_fin_mask->setChecked( false );
	c_urg_mask->setChecked( false );
	c_rst_mask->setChecked( false );
	c_psh_mask->setChecked( false );
	c_all_comp->setChecked( false );
	c_none_comp->setChecked( false );
	c_syn_comp->setChecked( false );
	c_ack_comp->setChecked( false );
	c_fin_comp->setChecked( false );
	c_urg_comp->setChecked( false );
	c_rst_comp->setChecked( false );
	c_psh_comp->setChecked( false );

	bool finished = false;
	IPTRuleOption* option;
	TQStringList vals;
	//################### start multiport options ######################
	option = rule->getOptionForName("tcp_multiport_opt");
	TQString enable = "";
	TQString src_port = "";
	TQString dest_port = "";
	vals = option->getValues();
	enable = "";
	enable = *vals.at(0);
	if ( enable == XML::BoolOn_Value ) {
		c_tcp->setChecked( true );
		c_udp->setEnabled( false );
		finished =true;
		c_all->setEnabled( false );
		c_icmp->setEnabled( false );
		tabWidget->setEnabled( true );
		toggleMultiPort( true );
		tabWidget->showPage( tab_ports );
	} else {
		option = rule->getOptionForName("udp_multiport_opt");
		vals = option->getValues();
		enable = "";
		enable = *vals.at(0);
		if ( enable == XML::BoolOn_Value ) {
			c_udp->setChecked( true );
			c_tcp->setEnabled( false );
			finished =true;
			c_all->setEnabled( false );
			c_icmp->setEnabled( false );
			tabWidget->setEnabled( true );
			toggleMultiPort( true );
			tabWidget->showPage( tab_multiport );
		}
	}

	src_port = "";
	dest_port = "";
	TQString equ_port = "";
	src_port = *vals.at(1);
	dest_port = *vals.at(2);
	equ_port = *vals.at(3);

	if ( !src_port.isEmpty() &&  src_port != XML::Undefined_Value && src_port != XML::BoolOff_Value)  {
		mpwid->setType( "src" );
		mpwid->loadPortString( src_port );
		kdDebug() << "Option Value -sport: " << src_port << endl;
	}
	if ( !dest_port.isEmpty() &&  dest_port != XML::Undefined_Value  && dest_port != XML::BoolOff_Value ) {
		mpwid->setType( "dest" );
		mpwid->loadPortString( dest_port );
		kdDebug() << "Option Value -sport: " << dest_port << endl;
	}
	if ( !equ_port.isEmpty() &&  equ_port != XML::Undefined_Value  && equ_port != XML::BoolOff_Value ) {
		mpwid->setType( "equ" );
		mpwid->loadPortString( equ_port );
		kdDebug() << "Option Value -sport: " << equ_port << endl;
	}
	if (finished)
		return;


	//################# start tcp options #########################
	option = rule->getOptionForName("tcp_opt");
	vals = option->getValues();
	TQString flags = "";
	TQString tcp_option = "";
	enable = *vals.at(0);
	src_port = *vals.at(1);
	dest_port = *vals.at(2);
	flags = *vals.at(3);
	tcp_option = *vals.at(4);
	if ( enable  == XML::BoolOn_Value ) {
		toggleMultiPort( false );
		toggleTcpRule( true );
		c_tcp->setChecked( true );
		c_all->setEnabled( false );
		c_udp->setEnabled( false );
		c_icmp->setEnabled( false );
		tabWidget->setEnabled( true );
		finished = true;
		tabWidget->showPage( tab_ports );
	}
	if ( !src_port.isEmpty() &&  src_port != XML::Undefined_Value && src_port != XML::BoolOff_Value)  {
		kdDebug() << "Option Value -sport: " << src_port << endl;
		c_src_port->setChecked( true );
		pw_src_port->loadPortString( src_port );
	}
	if ( !dest_port.isEmpty() &&  dest_port != XML::Undefined_Value  && dest_port != XML::BoolOff_Value ) {
		kdDebug() << "Option Value -dport: " << dest_port << endl;
		c_dest_port->setChecked( true );
		pw_dest_port->loadPortString( dest_port );
	}
	if ( !flags.isEmpty() &&  flags != XML::Undefined_Value && flags != XML::BoolOff_Value  ) {
		kdDebug() << "Option Value --tcp-flags: " << flags << endl;
		gb_mask->setEnabled( true );
		gb_comp->setEnabled( true );
		c_tcp_flags->setChecked( true );
		int delim = flags.find( " " );
		if ( flags.startsWith( "! " ) ) {
			c_inv_flags->setChecked( true );
			flags = flags.right( flags.length() - 2 );
		}
		delim = flags.find( " " );
		kdDebug() << "found Whitespace at " << delim << endl;
		TQString mask_lst = flags.left( delim );
		kdDebug() << "Flags for Mask: " << mask_lst << endl;
		TQString comp_lst = flags.right( flags.length() - delim );
		kdDebug() << "Flags for Comp: " << comp_lst << endl;

		if ( mask_lst.contains( "SYN" ) > 0 )
			c_syn_mask->setChecked( true );
		if ( mask_lst.contains( "ACK" ) > 0 )
			c_ack_mask->setChecked( true );
		if ( mask_lst.contains( "FIN" ) > 0 )
			c_fin_mask->setChecked( true );
		if ( mask_lst.contains( "RST" ) > 0 )
			c_rst_mask->setChecked( true );
		if ( mask_lst.contains( "URG" ) > 0 )
			c_urg_mask->setChecked( true );
		if ( mask_lst.contains( "PSH" ) > 0 )
			c_psh_mask->setChecked( true );
		if ( mask_lst.contains( "NONE" ) > 0 )
			c_none_mask->setChecked( true );
		if ( mask_lst.contains( "ALL" ) > 0 )
			c_all_mask->setChecked( true );

		if ( comp_lst.contains( "SYN" ) > 0 )
			c_syn_comp->setChecked( true );
		if ( comp_lst.contains( "ACK" ) > 0 )
			c_ack_comp->setChecked( true );
		if ( comp_lst.contains( "FIN" ) > 0 )
			c_fin_comp->setChecked( true );
		if ( comp_lst.contains( "RST" ) > 0 )
			c_rst_comp->setChecked( true );
		if ( comp_lst.contains( "URG" ) > 0 )
			c_urg_comp->setChecked( true );
		if ( comp_lst.contains( "PSH" ) > 0 )
			c_psh_comp->setChecked( true );
		if ( comp_lst.contains( "NONE" ) > 0 )
			c_none_comp->setChecked( true );
		if ( comp_lst.contains( "ALL" ) > 0 )
			c_all_comp->setChecked( true );
	}
	if ( !tcp_option.isEmpty() &&  tcp_option != XML::Undefined_Value && tcp_option != XML::BoolOff_Value  ) {
		kdDebug() << "Option Value --tcp-options: " << tcp_option << endl;
		c_tcp_option->setChecked( true );
		sb_tcp_option_num->setEnabled( true );
		if ( tcp_option.startsWith( "! " ) ) {
			c_inv_tcp_option->setChecked( true );
			tcp_option = tcp_option.right( tcp_option.length() - 2 );
		}
		int val = tcp_option.toInt();
		sb_tcp_option_num->setValue( val );

	}

	// Return if tcp option was used
	if (finished)
		return;
	//################# start udp options #########################
	option = rule->getOptionForName("udp_opt");
	vals = option->getValues();
	enable = "";
	src_port = "";
	dest_port = "";
	enable = *vals.at(0);
	src_port = *vals.at(1);
	dest_port = *vals.at(2);

	if ( enable == XML::BoolOn_Value ) {
		finished =true;
		toggleMultiPort( false );
		c_udp->setChecked( true );
		c_all->setEnabled( false );
		c_tcp->setEnabled( false );
		c_icmp->setEnabled( false );
		tabWidget->setEnabled( true );
		toggleUdpRule( true );
		tabWidget->showPage( tab_ports );
	}

	if ( !src_port.isEmpty() &&  src_port != XML::Undefined_Value && src_port != XML::BoolOff_Value)  {
		kdDebug() << "Option Value -sport: " << src_port << endl;
		c_src_port->setChecked( true );
		pw_src_port->loadPortString( src_port );
	}
	if ( !dest_port.isEmpty() &&  dest_port != XML::Undefined_Value  && dest_port != XML::BoolOff_Value ) {
		kdDebug() << "Option Value -dport: " << dest_port << endl;
		c_dest_port->setChecked( true );
		pw_dest_port->loadPortString( dest_port );
	}
	if (finished)
		return;
	//################# start icmp options #########################
	option = rule->getOptionForName("icmp_opt");
	vals = option->getValues();
	enable = "";
	TQString type =  "";
	enable = *vals.at(0);
	type = *vals.at(1);

	if ( enable == XML::BoolOn_Value ) {
		c_icmp->animateClick();
		if ( type != XML::Undefined_Value && !type.isEmpty() ) {
			if ( type.startsWith( "! " ) ) {
				c_inv_icmp->setChecked( true );
				type = type.right( type.length() - 2 );
			}
			int index = getItemNum( type );
			c_icmp_type->setChecked( true );
			if ( index > 0 ) {
				cb_icmp_type->setCurrentItem( index );
			}
			tabWidget->showPage( tab_icmp );
		}
	}

// 			if ( *opt == "all_prot" ) {
// 				c_all->animateClick();
// 			}
// 			if ( *opt == "icmp" ) {
// 				c_icmp->animateClick();
// 				for ( uint i = 0;i < options->count();i++ ) {
// 					kdDebug() << "OPTION VALUE: " << *options->at( i ) << endl;
// 					if ( i == 1 ) {
// 						TQString cmd = *options->at( i );
// 						kdDebug() << "Option Value -sport: " << cmd << endl;
// 						if ( cmd.startsWith( "! " ) ) {
// 							c_inv_icmp->setChecked( true );
// 							cmd = cmd.right( cmd.length() - 2 );
// 						}
// 						c_icmp_type->setChecked( true );
// 						cb_icmp_type->setEditText( cmd );
// 					}
// 				}
// 			}
}

void KMFRuleEditorProtocol::accept() {
	kdDebug() << "void KMFRuleEditorProtocol::accept()" << endl;
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 Protocol Option").arg( m_rule->name() ) 
	);

	///////////////////////////////////////////////////////
	// set options ++++++++++++++++++++++++++++++++++++++++
	TQString* tcp_multiport_name = new TQString("tcp_multiport_opt");
	TQString* udp_multiport_name = new TQString("udp_multiport_opt");
	TQString* tcp_name = new TQString("tcp_opt");
	TQString* udp_name = new TQString("udp_opt");
	TQString* icmp_name = new TQString("icmp_opt");
	TQString* all_name = new TQString("all_prot_opt");
	TQPtrList<TQString>* empty_opt = new TQPtrList<TQString>;
	empty_opt->append( new TQString(XML::BoolOff_Value) ); 
	m_rule->addRuleOption( *tcp_multiport_name, *empty_opt );
	m_rule->addRuleOption( *udp_multiport_name, *empty_opt );
	m_rule->addRuleOption( *tcp_name, *empty_opt );
	m_rule->addRuleOption( *udp_name, *empty_opt );
	m_rule->addRuleOption( *icmp_name, *empty_opt );
	m_rule->addRuleOption( *all_name, *empty_opt );
	
	if ( multiportEnabled() ) {
		kdDebug() << "You like a Multiport Rule" << endl;
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		TQString *s = new TQString( "" );
		mpwid->getPortString( s );
		TQString src = *s;
		kdDebug() << "Found Multiport:" << src << endl;
		if ( !src.isEmpty() ) {
			TQString type = "";
			type = mpwid->type();
			TQString* opt = new TQString( src );
			options->append( new TQString(XML::BoolOn_Value) );
			if ( type == "src" ) {
				options->append( new TQString( src ) );
			} else if ( type == "dest" ) {
				options->append( new TQString(XML::BoolOff_Value) );
				options->append( new TQString( src ) );
			} else if ( type == "equ" ) {
				options->append( new TQString(XML::BoolOff_Value) );
				options->append( new TQString(XML::BoolOff_Value) );
				options->append( new TQString( src ) );
			}
			kdDebug() << "Found Option Type: " << *opt << endl;
		}
		if ( c_tcp->isChecked() ) {
			m_rule->addRuleOption( *tcp_multiport_name, *options );
			options->clear();
			KMFUndoEngine::instance()->endTransaction();
			emit sigHideMe();

		} else if ( c_udp->isChecked() ) {
			m_rule->addRuleOption( *udp_multiport_name, *options );
			options->clear();
			KMFUndoEngine::instance()->endTransaction();
			emit sigHideMe();
		}
		return;
	}


	if ( c_tcp->isChecked() ) {
		kdDebug() << "You like a TCP Rule" << endl;
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		options->append( new TQString( XML::BoolOn_Value ) );
		TQString src = "";
		TQString dest = "";
		TQString flags = "";
		TQString tcp_option = "";

		if ( c_src_port->isChecked() ) {
			TQString * s = new TQString( "" );
			pw_src_port->getPortString( s );
			if ( !s->isEmpty() )
				src = *s;
			if ( src.isEmpty() ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
		}
		if ( c_dest_port->isChecked() ) {
			TQString * s = new TQString( "" );
			pw_dest_port->getPortString( s );
			if ( !s->isEmpty() )
				dest = *s;
			if ( dest.isEmpty() ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
		}
		if ( c_tcp_flags->isChecked() ) {
			if ( c_inv_flags->isChecked() ) {
				flags.prepend( "! " );
			}
			TQString mask = "";
			if ( ( c_all_comp->isChecked() || c_none_comp->isChecked() || c_syn_comp->isChecked() || c_fin_comp->isChecked() || c_ack_comp->isChecked() || c_rst_comp->isChecked() || c_urg_comp->isChecked() || c_psh_comp->isChecked() ) &&
					( c_all_mask->isChecked() || c_none_mask->isChecked() || c_syn_mask->isChecked() || c_fin_mask->isChecked() || c_ack_mask->isChecked() || c_rst_mask->isChecked() || c_urg_mask->isChecked() || c_psh_mask->isChecked() ) ) {
				if ( c_all_mask->isChecked() )
					mask.append( "ALL" );
				if ( c_none_mask->isChecked() )
					mask.append( "NONE" );
				if ( !c_all_mask->isChecked() && !c_none_mask->isChecked() ) {
					if ( c_syn_mask->isChecked() )
						mask.append( ",SYN" );
					if ( c_fin_mask->isChecked() )
						mask.append( ",FIN" );
					if ( c_ack_mask->isChecked() )
						mask.append( ",ACK" );
					if ( c_rst_mask->isChecked() )
						mask.append( ",RST" );
					if ( c_psh_mask->isChecked() )
						mask.append( ",PSH" );
					if ( c_urg_mask->isChecked() )
						mask.append( ",URG" );
					if ( mask.startsWith( "," ) )
						mask = mask.right( mask.length() - 1 );
				}
				TQString comp = "";
				if ( c_all_comp->isChecked() )
					comp.append( "ALL" );
				if ( c_none_comp->isChecked() )
					comp.append( "NONE" );
				if ( !c_all_comp->isChecked() && !c_none_comp->isChecked() ) {
					if ( c_syn_comp->isChecked() )
						comp.append( ",SYN" );
					if ( c_fin_comp->isChecked() )
						comp.append( ",FIN" );
					if ( c_ack_comp->isChecked() )
						comp.append( ",ACK" );
					if ( c_rst_comp->isChecked() )
						comp.append( ",RST" );
					if ( c_psh_comp->isChecked() )
						comp.append( ",PSH" );
					if ( c_urg_comp->isChecked() )
						comp.append( ",URG" );
				}

				if ( comp.startsWith( "," ) )
					comp = comp.right( comp.length() - 1 );
				flags.append( mask );
				flags.append( " " );
				flags.append( comp );
			} else {
				KMessageBox::sorry( this, i18n( "<qt><p>You need to select the TCP flags you like to "
												"check and those your rule should match.</qt>" ) );

				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
		}
		if ( c_tcp_option->isChecked() ) {
			tcp_option = sb_tcp_option_num->text();
			if ( c_inv_tcp_option->isChecked() ) {
				tcp_option.prepend( "! " );
			}
		}


			if ( src.isEmpty() )
				src = XML::BoolOff_Value;
			options->append( new TQString( src )  );
			if ( dest.isEmpty()  )
				dest = XML::BoolOff_Value;
			options->append( new TQString( dest )  );
			if ( flags.isEmpty() )
				flags = XML::BoolOff_Value;
			options->append( new TQString( flags )  );
			if ( tcp_option.isEmpty() )
				tcp_option = XML::BoolOff_Value;
			options->append( new TQString( tcp_option )  );
		m_rule->addRuleOption( *tcp_name, *options );
	}
	//////////////////////////////////////////////////////////////////
	// start udp options
	if ( c_udp->isChecked() ) {
		kdDebug() << "You like a UDP Rule" << endl;
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		TQString src = "";
		TQString dest = "";
		options->append( new TQString( XML::BoolOn_Value ) );

		if ( c_src_port->isChecked() ) {
			TQString * s = new TQString( "" );
			pw_src_port->getPortString( s );
			if ( !s->isEmpty() )
				src = *s;
			if ( src.isEmpty() ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
		}
		if ( c_dest_port->isChecked() ) {
			TQString * s = new TQString( "" );
			pw_dest_port->getPortString( s );
			if ( !s->isEmpty() )
				dest = *s;
			if ( dest.isEmpty() ) {
				KMFUndoEngine::instance()->abortTransaction();
				return ;
			}
		}
		if ( !src.isEmpty() || !dest.isEmpty() ) {
//			options->append( new TQString(XML::BoolOn_Value) );
			if ( src.isEmpty() )
				src = XML::BoolOff_Value;
			options->append( new TQString( src ) );
			if ( dest.isEmpty() )
				dest = XML::BoolOff_Value;
			options->append( new TQString( dest ) );
		}

		// emit sigAddRuleOpt( udp_name, options );
		m_rule->addRuleOption( *udp_name, *options );
		options->clear();
	}

	if ( c_icmp->isChecked() ) {
		kdDebug() << "You like a ICMP Rule" << endl;
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		TQString* opt = new TQString( "" );
		if ( c_icmp_type->isChecked() ) {
			opt = new TQString( cb_icmp_type->currentText() );
			if ( c_inv_icmp->isChecked() ) {
				opt->prepend( "! " );
			}
		}
		options->append( new TQString(XML::BoolOn_Value) );
		options->append( opt );
		// emit sigAddRuleOpt( icmp_name, options );
		m_rule->addRuleOption( *icmp_name, *options );
		options->clear();
	}

	if ( c_all->isChecked() ) {
		kdDebug() << "You like an ALL Rule" << endl;
		TQPtrList<TQString>* options = new TQPtrList<TQString>;
		options->append( new TQString(XML::BoolOn_Value) );
		// emit sigAddRuleOpt( all_name, options );
		m_rule->addRuleOption( *all_name, *options );
		options->clear();
	}

	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditorProtocol::slotHelp() {
	kapp->invokeHelp( "protocol" );
}
void KMFRuleEditorProtocol::reject() {
	emit sigHideMe();
}

}

#include "kmfruleeditorprotocol.moc"
