/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/
#ifndef KMFRULEEDITIP_H
#define KMFRULEEDITIP_H

#include "kmyfirewallruleeditorip.h"

// QT includes
#include <tqvariant.h>
#include <tqdialog.h>
#include <tqptrlist.h>

namespace KMF {
class IPTRule;
class KMFErrorHandler;
class KMFCheckInput;
class KMFError;
class KMFRuleEditIP : public KMyFirewallRuleEditorIP /*, virtual public KMFRuleOptionEditInterface */{
	TQ_OBJECT
  

public:
	KMFRuleEditIP( TQWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
	~KMFRuleEditIP();

// 	TQPtrList<TQString>* options;

	void loadRule( IPTRule * );
public slots:
	void accept();
	void reject();
	void slotHelp();

protected:
	TQVBoxLayout* KMyFirewallRuleEditorIPLayout;
	TQGridLayout* Layout85;
	TQGridLayout* GroupBox16Layout;
	TQHBoxLayout* Layout50;
	bool event( TQEvent* );

private:
	KMFCheckInput *m_CheckInput;
	KMFErrorHandler *m_ErrorHandler;
	IPTRule* m_rule;
	KMFError *m_err;

signals:
/*	void sigAddRuleOpt( TQString*, TQPtrList<TQString>* );
	void sigDelRuleOpt( TQString * );*/
	void sigDocumentChanged();
	void sigHideMe();
//	void sigAddUndo();
};
}






#endif // KMFRULEEDITIP_H
