/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#include "kmfruleeditip.h"
// qt includes
#include <tqcheckbox.h>
#include <tqframe.h>
#include <tqgroupbox.h>
#include <tqlabel.h>
#include <tqlineedit.h>
#include <tqpushbutton.h>
#include <tqlayout.h>
#include <tqvariant.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

// KDE includes
#include <kdebug.h>
#include <tdeapplication.h>
#include <tdelocale.h> 

// project includes
#include "../../core/xmlnames.h"
#include "../../core/iptrule.h"
#include "../../core/iptruleoption.h"
#include "../../core/iptchain.h"
#include "../../core/iptable.h"
#include "../../core/kmfdoc.h"
#include "../../core/kmfiptdoc.h"
#include "../../core/kmferror.h"
#include "../../core/kmfcheckinput.h"
#include "../../core/kmferrorhandler.h"
#include "../../core/kmfnetwork.h"
#include "../../core/kmfundoengine.h"

namespace KMF {
/*
 *  Constructs a KMFRuleEditIP which is a child of 'parent', with the
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
KMFRuleEditIP::KMFRuleEditIP( TQWidget* parent, const char* name, WFlags fl )
		: KMyFirewallRuleEditorIP ( parent, name, fl ) {
	m_CheckInput = new KMFCheckInput();
	m_ErrorHandler = new KMFErrorHandler( "KMFRuleEditIP" );
	m_err = new KMFError();
}

/*
 *  Destroys the object and frees any allocated resources
 */
KMFRuleEditIP::~KMFRuleEditIP() {
	// no need to delete child widgets, TQt does it all for us
}

/*
 *  Main event handler. Reimplemented to handle application
 *  font changes
 */
bool KMFRuleEditIP::event( TQEvent* ev ) {
	bool ret = TQWidget::event( ev );
	if ( ev->type() == TQEvent::ApplicationFontChange ) {}
	return ret;
}

void KMFRuleEditIP::loadRule( IPTRule * rule ) {
	kdDebug() << "void KMFRuleEditIP::loadRule( IPTRule * rule )" << endl;
	c_src_ip->setChecked( false );
	c_dest_ip->setChecked( false );
	c_inv_src_ip->setChecked( false );
	c_inv_dest_ip->setChecked( false );
	t_src_ip->setText( "" );
	t_dest_ip->clear();
	m_rule = rule;

	IPTRuleOption* opt = 0;
	opt = m_rule->getOptionForName("ip_opt");
	if ( opt ) {
		TQStringList args = opt->getValues();
		TQString src, dest;
		src = *args.at(0);
		dest = *args.at(1);

		if ( !src.isEmpty() && src != XML::Undefined_Value && src != XML::BoolOff_Value) {
			c_src_ip->setChecked( true );
			if ( src.startsWith( "! " ) ) {
				c_inv_src_ip->setChecked( true );
				t_src_ip->setText( src.right( src.length() - 2 ) );
			} else {
				t_src_ip->setText( src );
			}
		}
		if ( !dest.isEmpty() && dest != XML::Undefined_Value && dest != XML::BoolOff_Value ) {
			c_dest_ip->setChecked( true );
			if ( dest.startsWith( "! " ) ) {
				c_inv_dest_ip->setChecked( true );
				t_dest_ip->setText( dest.right( dest.length() - 2 ) );
			} else {
				t_dest_ip->setText( dest );
			}
		}

	}
	return ;
}


void KMFRuleEditIP::accept() {
	kdDebug() << "KMFRuleEditIP::slotOk()" << endl;
	KMFUndoEngine::instance()->startTransaction( 
		m_rule,
		i18n("Edit Rule: %1 IP Option").arg( m_rule->name() ) 
	);
	TQString* src_ip = new TQString( t_src_ip->text() );
	TQString* dest_ip = new TQString( t_dest_ip->text() );

	bool en_c_src_ip = c_src_ip->isChecked();
	bool en_c_dest_ip = c_dest_ip->isChecked();
	bool is_inv_src_ip = c_inv_src_ip->isChecked();
	bool is_inv_dest_ip = c_inv_dest_ip->isChecked();

	TQString* option_name = new TQString( "ip_opt" );
	TQPtrList<TQString>* args = new TQPtrList<TQString>;
	TQPtrList<TQString>* empty_args = new TQPtrList<TQString>;
	empty_args->append( new TQString(XML::BoolOff_Value) );
	empty_args->append(  new TQString(XML::BoolOff_Value) );
	m_rule->addRuleOption( *option_name, *empty_args );
	// emit sigAddRuleOpt( option_name, empty_args );

	if ( en_c_src_ip && !src_ip->isEmpty() ) {
		TQString cmd = *src_ip;
		// Sanity checks +++++++++++++++++
		m_CheckInput->checkInput( cmd, "IP/NETWORK/FTQHN", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		// ++++++++++++++++++++++++++++++++

		if ( is_inv_src_ip ) {
			src_ip->prepend( "! " );
		}
		args->append( src_ip );
	} else {
		args->append( new TQString(XML::BoolOff_Value) );
	}

	if ( en_c_dest_ip && !dest_ip->isEmpty() ) {
		kdDebug() << "Add new dest_ip option" << endl;
		TQString cmd = *dest_ip;
		// Sanity checks +++++++++++++++++
		m_CheckInput->checkInput( cmd, "IP/NETWORK/FTQHN", m_err );
		if ( !m_ErrorHandler->showError( m_err ) ) {
			KMFUndoEngine::instance()->abortTransaction();
			return ;
		}
		// ++++++++++++++++++++++++++++++++
		if ( is_inv_dest_ip ) {
			dest_ip->prepend( "! " );
		}
		args->append( dest_ip );
	}  else {
		args->append( new TQString(XML::BoolOff_Value) );
	}

	m_rule->addRuleOption( *option_name, *args );
	KMFUndoEngine::instance()->endTransaction();
	emit sigHideMe();
}

void KMFRuleEditIP::reject() {
	kdDebug() << "void KMFRuleEditIP::reject()" << endl;
	emit sigHideMe();
}

void KMFRuleEditIP::slotHelp() {
	kdDebug() << "void KMFRuleEditIP::slotHelp()" << endl;
	kapp->invokeHelp( "src_dest_ip" );
}


}


#include "kmfruleeditip.moc"
