/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
/*
Author: Christian Hubinger <chubinger@irrsinnig.org>, (C) 2001-2004
*/

#ifndef KMFCONFIGDIALOG_H
#define KMFCONFIGDIALOG_H

#include <tqwidget.h>
#include <kdialogbase.h>
#include <tdeconfig.h>
#include <tdeglobal.h>
#include <kprocess.h>
#include <tqstring.h>
#include <tqpixmap.h>


#include "core/kmfcompilerinterface.h"

class TQFrame;
class TQCheckBox;
class TQRadioButton;
class TQButtonGroup;
class KURLRequester;
class KPushButton;
class KComboBox;
class TDEListBox;
class KIntSpinBox;

namespace KMF {
class KMFCheckListOutput;
class KMFInterfaceWidget;
class KMFMyNetworkWidget;
class KMFNetwork;
class KMFGenericInterfaceEditProtocol;

class KMFConfigDialog : public KDialogBase {
	TQ_OBJECT
  

public:
	KMFConfigDialog( TQWidget *parent = 0, const char *name = 0, bool modal = true );
	~KMFConfigDialog();
	void setNetwork( KMFNetwork* );
	void registerCompiler( KMFCompilerInterface* );
	void convertConfig();
	void exec();
	
public slots:
	void slotReadConfig();
	void slotSaveConfig();

private slots:
	void slotEnableGenericInterface( bool );
	void slotEnableWarnings();
	// void slotEnableLocalSSHUsage( bool enable );
	void slotApply();
	void accept();
	void reject();
	
private:  // members
	void setupListView();
	void setupGeneral();
	void setupCustomProtocols();
	void setupPlugins();
	void checkPlugins();
	void loadIcons();

private:  // data
	KMFNetwork *m_network;

	// General
	TQCheckBox *m_cb_show_splash;
	TQCheckBox *m_cb_show_selInterface;
	TQCheckBox *m_cb_generic_interface;
	TQCheckBox *m_cb_useSSHForLocalhost;
	KIntSpinBox *m_sb_max_undo;
	KPushButton *m_b_enable_warnings;

	KMFGenericInterfaceEditProtocol *m_protocolPageEditProtocol;
	
	// Path widget
 	TQPtrList<TQStringList> *m_backends;


	TQPixmap icon_paths, icon_interfaces, icon_general, icon_listview, icon_edit_protocol_page;
	TQFrame * pageGeneric;
	
	// ListView
	TQCheckBox *m_cb_show_cmds;
	TQCheckBox *m_cb_show_desc;
	TQCheckBox *m_cb_show_objectID;
	TQLabel *m_lvp_text1, *m_lvp_text2, *m_lvp_text3;
	
	// Plugins
	TDEListView *m_lv_plugins;
signals:
	void sigConfigChanged();
};
}
#endif
