/***************************************************************************
*   Copyright (C) 2005 by Alexander Nemish  *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#include <kdialog.h>
#include <tdelocale.h>
#include <tqvariant.h>
#include <tqpushbutton.h>
#include <tqheader.h>
#include <tqtable.h>
#include <tqlayout.h>
#include <tqtooltip.h>
#include <tqwhatsthis.h>

#include "bookmarksdlg.h"
/*
 *  Constructs a BookmarksDlg as a child of 'parent', with the
 *  name 'name' and widget flags set to 'f'.
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */

BookmarksDlg::BookmarksDlg(const Bookmarks& bms, TQWidget* parent,
                           const char* name, bool modal, WFlags fl)
		: TQDialog(parent, name, modal, fl),
		m_bookmarks(bms)
{
	if ( !name )
		setName( "BookmarksDlg" );
	setSizeGripEnabled(TRUE);
	BookmarksDlgLayout = new TQVBoxLayout( this, 11, 6, "BookmarksDlgLayout");

	layout3 = new TQHBoxLayout( 0, 0, 6, "layout3");

	bookmarksTable = new TQTable(3, 2, this, "bookmarksList" );
	bookmarksTable->horizontalHeader()->setLabel(0, "Title");
	bookmarksTable->horizontalHeader()->setLabel(1, "Page number");
// 	bookmarksTable->setLeftMargin(0);
	bookmarksTable->setColumnStretchable(0, true);
	bookmarksTable->setSelectionMode(TQTable::SingleRow);
	layout3->addWidget( bookmarksTable );

	layout2 = new TQVBoxLayout( 0, 0, 6, "layout2");

	addButton = new TQPushButton( this, "addButton" );
	layout2->addWidget( addButton );

	deleteButton = new TQPushButton( this, "deleteButton" );
	layout2->addWidget( deleteButton );
	Horizontal_Spacing2_2 = new TQSpacerItem( 20, 60, TQSizePolicy::Minimum, TQSizePolicy::Expanding );
	layout2->addItem( Horizontal_Spacing2_2 );
	layout3->addLayout( layout2 );
	BookmarksDlgLayout->addLayout( layout3 );

	Layout1 = new TQHBoxLayout( 0, 0, 6, "Layout1");

	buttonHelp = new TQPushButton( this, "buttonHelp" );
	buttonHelp->setAutoDefault( TRUE );
	Layout1->addWidget( buttonHelp );
	Horizontal_Spacing2 = new TQSpacerItem( 20, 20, TQSizePolicy::Expanding, TQSizePolicy::Minimum );
	Layout1->addItem( Horizontal_Spacing2 );

	buttonOk = new TQPushButton( this, "buttonOk" );
	buttonOk->setAutoDefault( TRUE );
	buttonOk->setDefault( TRUE );
	Layout1->addWidget( buttonOk );

	buttonCancel = new TQPushButton( this, "buttonCancel" );
	buttonCancel->setAutoDefault( TRUE );
	Layout1->addWidget( buttonCancel );
	BookmarksDlgLayout->addLayout( Layout1 );
	languageChange();
	resize( TQSize(400, 267).expandedTo(minimumSizeHint()) );
	clearWState( WState_Polished );

	updateBookmarks();
	// signals and slots connections
	connect(buttonOk, TQT_SIGNAL(clicked()), this, TQT_SLOT(accept()));
	connect(buttonCancel, TQT_SIGNAL(clicked()), this, TQT_SLOT(reject()));
	connect(addButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(addBookmark()));
	connect(deleteButton, TQT_SIGNAL(clicked()), this, TQT_SLOT(deleteBookmark()));
	connect(bookmarksTable, TQT_SIGNAL(valueChanged(int, int)), this, TQT_SLOT(valueChanged(int, int)));
}

/*
 *  Destroys the object and frees any allocated resources
 */
BookmarksDlg::~BookmarksDlg()
{
	// no need to delete child widgets, TQt does it all for us
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void BookmarksDlg::languageChange()
{
	setCaption( tr2i18n( "Bookmarks editor" ) );
	addButton->setText( tr2i18n( "Add" ) );
	deleteButton->setText( tr2i18n( "Delete" ) );
	buttonHelp->setText( tr2i18n( "&Help" ) );
	buttonHelp->setAccel( TQKeySequence( tr2i18n( "F1" ) ) );
	buttonOk->setText( tr2i18n( "&OK" ) );
	buttonCancel->setText( tr2i18n( "Ca&ncel" ) );
}

void BookmarksDlg::addBookmark()
{
	m_bookmarks.push_back(Bookmark(2, "new bookmark"));
	std::sort(m_bookmarks.begin(), m_bookmarks.end());
	updateBookmarks();
}

void BookmarksDlg::deleteBookmark()
{
	int row = bookmarksTable->currentRow();
	if (row >= 0 && row < m_bookmarks.size())
	{
		m_bookmarks.erase(m_bookmarks.begin() + row);
		updateBookmarks();
	}
}

void BookmarksDlg::updateBookmarks()
{
	bookmarksTable->setNumRows(0);
	for (Bookmarks::size_type i = 0; i < m_bookmarks.size(); ++i)
	{
		const Bookmark& bm = m_bookmarks[i];
		bookmarksTable->setNumRows(i+1);
		bookmarksTable->setText(i, 0, bm.name());
		bookmarksTable->setText(i, 1, TQString::number(bm.page()));
	}	
}

void BookmarksDlg::valueChanged(int row, int col)
{
	if (row >= m_bookmarks.size()) return;
	Bookmark& bm = m_bookmarks[row];
	//Bookmark title
	if (col == 0)
		bm.setName(bookmarksTable->text(row, col));
	//page number
	else if (col == 1)
	{
		bool ok;
		unsigned int page = bookmarksTable->text(row, col).toUInt(&ok);
		if (ok)
			bm.setPage(page);
		else
			//return old value
			bookmarksTable->setText(row, col, TQString::number(bm.page()));
	}
}

#include "bookmarksdlg.moc"
