#!/usr/bin/python
# -*- coding: UTF-8 -*-
###########################################################################
# wineconfig.py - description                                             #
# ------------------------------                                          #
# begin     : Fri Mar 26 2004                                             #
# copyright : (C) 2006 by Yuriy Kozlov                                    #
# email     : yuriy.kozlov@gmail.com                                      #
#                                                                         #
###########################################################################
#                                                                         #
#   This program is free software; you can redistribute it and/or modify  #
#   it under the terms of the GNU General Public License as published by  #
#   the Free Software Foundation; either version 2 of the License, or     #
#   (at your option) any later version.                                   #
#                                                                         #
###########################################################################

from PyTQt.tqt import *
from tdecore import *
from tdeui import *
from tdefile import *
from tdeio import *
import os
import sys
import signal
import wineread
import winewrite
import drivedetect

class FirstRunWizard(KWizard):
    default_winepath = os.environ['HOME'] + "/.wine"
    
    def __init__(self, parent = None, name=None, modal=0, fl=0):
        KWizard.__init__(self,parent,name,modal,fl)
        
        if not name:
            self.setName("firstrunwizard")
            
        self.imagedir = str(TDEGlobal.dirs().findDirs("data","guidance/pics")[0])
            
        self.setupPage1()
        self.setupPageVersion()
        self.setupPageExistingWine()
        self.setupPageCreateWine()
        self.slotCreateExistingToggled(0)
        #self.connect(self,SIGNAL("selected(const TQString &)"),self.slotPageChanged)
        
        #self.resize(TQSize(600,480).expandedTo(self.minimumSizeHint()))
        self.clearWState(TQt.WState_Polished)
            
    def setupPage1(self):
        page1 = TQHBox(self,"page1")
        
        self.kdewinepicture = TQLabel(page1,"kdewinepicture")
        self.kdewinepicture.setSizePolicy(TQSizePolicy(TQSizePolicy.Fixed,TQSizePolicy.Fixed,0,0,self.kdewinepicture.sizePolicy().hasHeightForWidth()))
        self.kdewinepicture.setMinimumSize(TQSize(140,320))
        self.kdewinepicture.setPixmap(TQPixmap(self.imagedir+"kdewinewizard.png"))
        #self.kdewinepicture.setScaledContents(1)
        
        spacer = TQWidget(page1)
        spacer.setMinimumSize(TQSize(6,300))
        
        pagebody = TQVBox(page1,"pagebody")
        page1.setStretchFactor(pagebody,1)
        
        introtext = TQLabel(pagebody,"introtext")
        introtext.setText(i18n("It appears that you do not yet have a Windows drive set up.\n" +\
            "This wizard will help set it up so that you can run windows applications.\n"))
        
        spacer = TQWidget(pagebody)
        spacer.setMinimumSize(TQSize(6,20))
        
        self.createinstall = True
        
        createwinepathchoice = TQRadioButton(i18n("Set up the fake windows installation " +\
            "in the following directory:"),pagebody)
            
        self.winepath = self.default_winepath
        hbox = TQHBox(pagebody)
        hbox.setSpacing(KDialog.spacingHint())
        
        self.winefolderedit = KLineEdit(self.winepath,hbox)
        self.urlcompletion = KURLCompletion(KURLCompletion.DirCompletion)
        self.winefolderedit.setCompletionObject(self.urlcompletion)
        self.winefolderedit.setCompletionMode(TDEGlobalSettings.CompletionPopup)
        self.connect(self.winefolderedit,SIGNAL("textChanged(const TQString &)"),self.slotWineFolderEdited)
        
        self.browsecreatebutton = KPushButton(i18n("Browse"),hbox)
        self.connect(self.browsecreatebutton,SIGNAL("clicked()"),self.slotBrowseClicked)
        
        spacer = TQWidget(pagebody)
        spacer.setMinimumSize(TQSize(6,10))
        
        existingwinepathchoice = TQRadioButton(i18n("There is already a fake windows installation " +\
            "in the following directory:"),pagebody)
            
        hbox = TQHBox(pagebody)
        hbox.setSpacing(KDialog.spacingHint())
        
        self.existingwinefolderedit = KLineEdit("",hbox)
        self.urlcompletion = KURLCompletion(KURLCompletion.DirCompletion)
        self.existingwinefolderedit.setCompletionObject(self.urlcompletion)
        self.existingwinefolderedit.setCompletionMode(TDEGlobalSettings.CompletionPopup)
        self.connect(self.existingwinefolderedit,SIGNAL("textChanged(const TQString &)"),self.slotWineFolderEdited)
        
        self.browseexistingbutton = KPushButton(i18n("Browse"),hbox)
        self.connect(self.browseexistingbutton,SIGNAL("clicked()"),self.slotBrowseClicked)
        
        self.createexistingchoicesgroup = TQButtonGroup(pagebody,"createexistingchoicesgroup")
        self.createexistingchoicesgroup.insert(createwinepathchoice,0)
        self.createexistingchoicesgroup.insert(existingwinepathchoice,1)
        self.createexistingchoicesgroup.setExclusive(True)
        self.createexistingchoicesgroup.hide()
        self.createexistingchoicesgroup.setButton(0)
        self.connect(self.createexistingchoicesgroup,SIGNAL("clicked(int)"),self.slotCreateExistingToggled)
        
        bottomspacer = TQWidget(pagebody)
        pagebody.setStretchFactor(bottomspacer,1)
        
        self.addPage( page1, i18n("Setting up your windows drive") )

        self.setBackEnabled( page1, False )
        self.setNextEnabled( page1, True )
        self.setHelpEnabled( page1, False )
        self.setFinishEnabled( page1, False )
        
    def setupPageExistingWine(self):
        self.pageexisting = TQHBox(self,"pageexisting")
        
        self.kdewinepicture = TQLabel(self.pageexisting,"kdewinepicture")
        self.kdewinepicture.setSizePolicy(TQSizePolicy(TQSizePolicy.Fixed,TQSizePolicy.Fixed,0,0,self.kdewinepicture.sizePolicy().hasHeightForWidth()))
        self.kdewinepicture.setMinimumSize(TQSize(140,320))
        self.kdewinepicture.setPixmap(TQPixmap(self.imagedir+"kdewinewizard.png"))
        #self.kdewinepicture.setScaledContents(1)
        
        spacer = TQWidget(self.pageexisting)
        spacer.setMinimumSize(TQSize(6,300))
        
        valid = wineread.VerifyWineDrive(self.winepath)
        
        pagebody = TQVBox(self.pageexisting,"pagebody")
        self.pageexisting.setStretchFactor(pagebody,1)
        
        existstext = TQLabel(pagebody,"existstext")
        if valid:
            existstext.setText(i18n("A fake windows installation was found."))
        else:
            existstext.setText(i18n("No fake windows installation was found in\n" +\
                self.winepath + "\nPlease go back and create one."))
            
        bottomspacer = TQWidget(pagebody)
        pagebody.setStretchFactor(bottomspacer,1)
        
        self.addPage( self.pageexisting, i18n("Setting up your windows drive") )

        self.setBackEnabled( self.pageexisting, True )
        self.setNextEnabled( self.pageexisting, True )
        self.setHelpEnabled( self.pageexisting, False )
        self.setFinishEnabled( self.pageexisting, True )
        
    def setupPageCreateWine(self):
        self.pagecreate = TQHBox(self,"pagecreate")
        
        self.kdewinepicture = TQLabel(self.pagecreate,"kdewinepicture")
        self.kdewinepicture.setSizePolicy(TQSizePolicy(TQSizePolicy.Fixed,TQSizePolicy.Fixed,0,0,self.kdewinepicture.sizePolicy().hasHeightForWidth()))
        self.kdewinepicture.setMinimumSize(TQSize(140,320))
        self.kdewinepicture.setPixmap(TQPixmap(self.imagedir+"kdewinewizard.png"))
        #self.kdewinepicture.setScaledContents(1)
        
        spacer = TQWidget(self.pagecreate)
        spacer.setMinimumSize(TQSize(6,300))
        
        pagebody = TQVBox(self.pagecreate,"pagebody")
        self.pagecreate.setStretchFactor(pagebody,1)
        
        self.createdtext = TQLabel(pagebody,"existstext")
        self.createdtext.setText(i18n("A fake windows installation was created for you in\n" +\
            self.winepath))
            
        bottomspacer = TQWidget(pagebody)
        pagebody.setStretchFactor(bottomspacer,1)
        
        self.addPage( self.pagecreate, i18n("Setting up your windows drive") )

        self.setBackEnabled( self.pagecreate, False )
        self.setNextEnabled( self.pagecreate, True )
        self.setHelpEnabled( self.pagecreate, False )
        self.setFinishEnabled( self.pagecreate, True )
        
    def setupPageVersion(self):
        self.pageversion = TQHBox(self,"pageversion")
        
        self.kdewinepicture = TQLabel(self.pageversion,"kdewinepicture")
        self.kdewinepicture.setSizePolicy(TQSizePolicy(TQSizePolicy.Fixed,TQSizePolicy.Fixed,0,0,self.kdewinepicture.sizePolicy().hasHeightForWidth()))
        self.kdewinepicture.setMinimumSize(TQSize(140,320))
        self.kdewinepicture.setPixmap(TQPixmap(self.imagedir+"kdewinewizard.png"))
        #self.kdewinepicture.setScaledContents(1)
        
        spacer = TQWidget(self.pageversion)
        spacer.setMinimumSize(TQSize(6,300))
        
        pagebody = TQVBox(self.pageversion,"pagebody")
        self.pageversion.setStretchFactor(pagebody,1)
        
        versiontext = TQLabel(pagebody,"versiontext")
        versiontext.setText(i18n("What windows version would you like to emulate?\n"))
        
        self.winversions = wineread.winversions
        
        self.verid=1
        self.versioncombo = KComboBox(0,pagebody,"versioncombo")
        self.fillVersionCombo(self.versioncombo)
        self.connect(self.versioncombo,SIGNAL("activated(int)"),self.slotVersionActivated)
        self.__selectWinVer(self.verid)
            
        bottomspacer = TQWidget(pagebody)
        pagebody.setStretchFactor(bottomspacer,1)
        
        self.addPage( self.pageversion, i18n("Setting up your windows drive") )

        self.setBackEnabled( self.pageversion, True )
        self.setNextEnabled( self.pageversion, True )
        self.setHelpEnabled( self.pageversion, False )
        self.setFinishEnabled( self.pageversion, False )
        
    def fillVersionCombo(self,combo):
        """ Fill the combobox with the values from our list """
        for version in self.winversions:
            combo.insertItem(version[1])
            
    def __selectWinVer(self,verid):
        """
        Sets the current windows version and selects it in the combo box
        """
        self.versioncombo.setCurrentItem(verid)
        
    def slotVersionActivated(self,verid):
        self.verid = verid
    
    def slotFolderChanged(self,folder):
        """ Change the directory when a new one is entered in the URL box """
        self.winepath = str(folder)
                
    def slotWineFolderEdited(self,folder):
        """ Change the directory when a new one is entered manually in the URL box """
        self.urlcompletion.makeCompletion("")   # Doesn't seem like this should be required.
        self.slotFolderChanged(folder)

    def slotBrowseClicked(self):
        """ Bring up a browse window to choose a  directory """
        path = KFileDialog.getExistingDirectory(wineread.winepath,self,i18n("Windows Directory"))
        if path:
            self.winepath = str(path)
    
    #def slotPageChanged(self,pagename):
    #    if pagename == "pagecreate":
    #        self.CreateWindowsInstall()
            
    def slotCreateExistingToggled(self, buttonid):
        """ Called when the choice to create a new windows drive or use an existing one is changed """
        if buttonid == 0:
            self.createinstall = True
            self.winefolderedit.setEnabled(True)
            self.browsecreatebutton.setEnabled(True)
            self.existingwinefolderedit.setEnabled(False)
            self.browseexistingbutton.setEnabled(False)
            self.setAppropriate(self.pageversion,True)
            self.setAppropriate(self.pageexisting,False)
            self.setAppropriate(self.pagecreate,True)
        elif buttonid == 1:
            self.createinstall = False
            self.winefolderedit.setEnabled(False)
            self.browsecreatebutton.setEnabled(False)
            self.existingwinefolderedit.setEnabled(True)
            self.browseexistingbutton.setEnabled(True)
            self.setAppropriate(self.pageversion,False)
            self.setAppropriate(self.pageexisting,True)
            self.setAppropriate(self.pagecreate,False)
            
    def showPage(self,page):
        if page == self.pagecreate:
            self.CreateWindowsInstall()
            
        KWizard.showPage(self,page)
    
    def CreateWindowsInstall(self):
        winewrite.CreateWineDrive(self.winepath)
        wineread.SetWinePath(self.winepath)
	
        autodrives = drivedetect.autodetect()
        autoshelllinks = drivedetect.autodetectshelllinks()
        
        if autodrives[0] == 1:
            KMessageBox.sorry(self, \
                i18n("There were not enough letters to add all the autodetected drives."))
        drives = autodrives[1]
        drives[26:] = autoshelllinks
        
        winewrite.SetDriveMappings(drives)
        
        winewrite.SetAudioDriver('alsa')
        
        dsoundsettings = {"HardwareAcceleration":"Full",
            "DefaultSampleRate":"44100",
            "DefaultBitsPerSample":"8",
            "EmulDriver":"N"}
            
        winewrite.SetDSoundSettings(dsoundsettings)
        
        windowsettings = {"DXGrab":"N",
            "DesktopDoubleBuffered":"Y",
            "Managed":"Y",
            "Desktop":""}
            
        winewrite.SetWindowSettings(windowsettings)
        
        d3dsettings = {"VertexShaderMode":"hardware",
            "PixelShaderMode":"Y"}
            
        winewrite.SetD3DSettings(d3dsettings)
        
        winewrite.SetWinVersion(self.winversions[self.verid])
	
	self.createdtext.setText(i18n("A fake windows installation was created for you in\n" +\
            self.winepath))
