/***************************************************************************
                          knightspixcache.cpp  -  description
                             -------------------
    begin                : Mon Aug 20 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knightspixcache.h"
#include "definitions.h"

KnightsPixCache::KnightsPixCache()
{
	bytesTotal = 1024 * 1024;
	bytesUsed = 0;
}
KnightsPixCache::~KnightsPixCache()
{
	clear();
	bytesUsed = 0;
}
///////////////////////////////////////
//
//	KnightsPixCache::cacheLimit
//
///////////////////////////////////////
unsigned int KnightsPixCache::cacheLimit( void )
{
	return ( bytesTotal / 1024 );
}
///////////////////////////////////////
//
//	KnightsPixCache::setCacheLimit
//
///////////////////////////////////////
void KnightsPixCache::setCacheLimit( const unsigned int &limit )
{
	bytesTotal = limit * 1024;
}
///////////////////////////////////////
//
//	KnightsPixCache::clear
//
///////////////////////////////////////
void KnightsPixCache::clear( void )
{
	list.clear();
}
///////////////////////////////////////
//
//	KnightsPixCache::cleanCache
//
///////////////////////////////////////
void KnightsPixCache::cleanCache( const unsigned int &space )
{
	pixmapList::Iterator	tmpIT;
	unsigned int age;

	while( bytesUsed + space > bytesTotal )
	{
		if( list.count() == 0 ) return;
		age = 0;
		for( IT = list.begin(); IT != list.end(); ++IT )
		{
			if( (*IT).age > age )
			{
				age = (*IT).age;
				tmpIT = IT;
			}
		}
		bytesUsed -= (*tmpIT).bytes;
		list.remove( tmpIT );
	}
}
///////////////////////////////////////
//
//	KnightsPixCache::add
//
///////////////////////////////////////
void KnightsPixCache::add( const TQString &label, const TQPixmap &pixmap )
{
	unsigned int tmp;
	cacheItem newItem;

	if( pixmap.isNull() )
		return;
	tmp = ( pixmap.width() * pixmap.height() * pixmap.depth() ) >> 3;
	if( ( bytesUsed + tmp ) > bytesTotal )
		cleanCache(tmp);
	
	newItem.label = label;
	newItem.bytes = tmp;
	newItem.item = pixmap;
	newItem.age = 0;
	list.append( newItem );
	bytesUsed += tmp;
}
///////////////////////////////////////
//
//	KnightsPixCache::find
//
///////////////////////////////////////
bool KnightsPixCache::find( const TQString &label, TQPixmap &pixmap )
{
	bool status(FALSE);
	for( IT = list.begin(); IT != list.end(); ++IT )
	{
		if( (*IT).label == label )
		{
			pixmap = (*IT).item;
			(*IT).age = 0;
			status = TRUE;
		}
		else
			(*IT).age++;
	}
	return status;
}
///////////////////////////////////////
//
//	KnightsPixCache::resize
//
///////////////////////////////////////
void KnightsPixCache::resize( const int &size )
{
	SquareLight.convertFromImage( Orig_SquareLight.smoothScale( size, size ) );
	SquareDark.convertFromImage( Orig_SquareDark.smoothScale( size, size ) );
	HighlightSelect.convertFromImage( Orig_HighlightSelect.smoothScale( size, size ) );
	HighlightMove.convertFromImage( Orig_HighlightMove.smoothScale( size, size ) );
	HighlightAttack.convertFromImage( Orig_HighlightAttack.smoothScale( size, size ) );
	BlackKing.convertFromImage( Orig_BlackKing.smoothScale( size, size ) );
	BlackQueen.convertFromImage( Orig_BlackQueen.smoothScale( size, size ) );
	BlackBishop.convertFromImage( Orig_BlackBishop.smoothScale( size, size ) );
	BlackKnight.convertFromImage( Orig_BlackKnight.smoothScale( size, size ) );
	BlackRook.convertFromImage( Orig_BlackRook.smoothScale( size, size ) );
	BlackPawn.convertFromImage( Orig_BlackPawn.smoothScale( size, size ) );
	WhiteKing.convertFromImage( Orig_WhiteKing.smoothScale( size, size ) );
	WhiteQueen.convertFromImage( Orig_WhiteQueen.smoothScale( size, size ) );
	WhiteBishop.convertFromImage( Orig_WhiteBishop.smoothScale( size, size ) );
	WhiteKnight.convertFromImage( Orig_WhiteKnight.smoothScale( size, size ) );
	WhiteRook.convertFromImage( Orig_WhiteRook.smoothScale( size, size ) );
	WhitePawn.convertFromImage( Orig_WhitePawn.smoothScale( size, size ) );
	Border.convertFromImage( Orig_Border.smoothScale( size * 9, size * 9) );
	BorderLightOn.convertFromImage( Orig_BorderLightOn.smoothScale( size / 2, size / 2) );
	BorderLightOff.convertFromImage( Orig_BorderLightOff.smoothScale( size / 2, size / 2) );
	return;
}
