/***************************************************************************
                          dlg_engine.cpp  -  description
                             -------------------
    begin                : Wed Jul 18 2001
    copyright            : (C) 2003 by Troy Corbin Jr.
    email                : tcorbin@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <tdefiledialog.h>
#include <kicontheme.h>
#include "dlg_engine.moc"

dlg_engine::dlg_engine(TQWidget *parent, const char *name, resource *Rsrc, TQString ItemName ) :
	KDialogBase(	parent,
								name,
								TRUE,
								i18n("Configure Engine"),
								Help|Ok|Apply|Cancel,
								Ok,
								TRUE )
{
	Resource = Rsrc;
	Name = ItemName;

	BOX_Parent = makeVBoxMainWidget();
	BOX_NameProto = new TQHBox( BOX_Parent );
	BOX_Name = new TQGroupBox( 1,
														Qt::Horizontal,
														i18n( "Engine Name" ),
														BOX_NameProto );
	EDIT_Name = new KLineEdit( BOX_Name );
	BOX_Protocol = new TQGroupBox( 1,
																Qt::Horizontal,
																i18n( "Protocol" ),
																BOX_NameProto );
	EDIT_Protocol = new KComboBox( BOX_Protocol );
	BOX_Filename = new TQGroupBox( 2,
																Qt::Horizontal,
																i18n( "Engine Filename" ),
																BOX_Parent );
	EDIT_Filename = new KLineEdit( BOX_Filename );
	BUTTON_Filename = new TQPushButton( BOX_Filename );
	BOX_Arguments = new TQGroupBox( 1,
																	Qt::Horizontal,
																	i18n( "Command Line Arguments" ),
																	BOX_Parent );
	EDIT_Arguments = new KLineEdit( BOX_Arguments );
	BOX_LogFile = new TQGroupBox( 2,
																Qt::Horizontal,
																i18n( "Log File" ),
																BOX_Parent );
	EDIT_LogFile = new KLineEdit( BOX_LogFile );
	BUTTON_LogFile = new TQPushButton( BOX_LogFile );
	setMainWidget( BOX_Parent );
	BUTTON_Filename->setPixmap( Resource->LoadIcon( TQString( "document-open" ), TDEIcon::Toolbar ) );
	BUTTON_LogFile->setPixmap( Resource->LoadIcon( TQString( "document-open" ), TDEIcon::Toolbar ) );
	EDIT_Name->setMinimumWidth( 150 );
	EDIT_Filename->setMinimumWidth( 300 );
	EDIT_Arguments->setMinimumWidth( 300 );
	/* Protocol ComboBox */
	EDIT_Protocol->insertItem( TQString( "XBoard" ) );
	EDIT_Protocol->insertItem( TQString( "UCI" ) );
	EDIT_Protocol->setEditable( FALSE );
	/* Load in data if this is a modification */
	if( !Name.isEmpty() )
	{
		for ( enginesIT = Resource->engines.begin(); enginesIT != Resource->engines.end(); ++enginesIT )
		{
			if( (*enginesIT).Name == Name ) break;
		}
		EDIT_Name->setText( (*enginesIT).Name );
		EDIT_Filename->setText( (*enginesIT).Filename );
		EDIT_Arguments->setText( (*enginesIT).Arguments );
		EDIT_LogFile->setText( (*enginesIT).LogFile );
		switch( (*enginesIT).Protocol )
		{
			case XBoard:
				EDIT_Protocol->setCurrentItem(0);
				break;
			case UCI:
				EDIT_Protocol->setCurrentItem(1);
				break;
			default:
				break;
		}
	}
	/* Init the buttons */
	showButtonCancel( TRUE );
	showButtonOK( TRUE );
	showButtonApply( TRUE );
	showButton( Help, TRUE );

	enableButtonCancel( TRUE );
	enableButtonOK( TRUE );
	enableButtonApply( FALSE );
	enableButton( Help, TRUE );

	setHelp( TQString( "configure-engines" ) );
	/* Make Connections */
	connect( BUTTON_Filename, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotFilenameDialog() ) );
	connect( BUTTON_LogFile, TQT_SIGNAL( clicked() ), this, TQT_SLOT( slotLogFileDialog() ) );
	connect( EDIT_Protocol, TQT_SIGNAL( activated(int) ), this, TQT_SLOT( slotProtocol(int) ) );
	show();
}
///////////////////////////////////////
//
//	dlg_engine::~dlg_engine
//
///////////////////////////////////////
dlg_engine::~dlg_engine()
{
}
///////////////////////////////////////
//
//	dlg_engine::slotOk
//
///////////////////////////////////////
void dlg_engine::slotOk( void )
{
	slotApply();
	slotDelayedDestruct();
}
///////////////////////////////////////
//
//	dlg_engine::slotApply
//
///////////////////////////////////////
void dlg_engine::slotApply( void )
{
	engineResource newEngine;

	if( Name.isEmpty() )
	{
		enginesIT = Resource->engines.append( newEngine );
		Name = "notemptyanymore";
		(*enginesIT).Wins = 0;
		(*enginesIT).Losses = 0;
		(*enginesIT).Draws = 0;
		(*enginesIT).CurrentRef = 0;
	}
	(*enginesIT).Name = EDIT_Name->text();
	(*enginesIT).Filename = EDIT_Filename->text();
	(*enginesIT).Arguments = EDIT_Arguments->text();
	(*enginesIT).LogFile = EDIT_LogFile->text();
	switch( EDIT_Protocol->currentItem() )
	{
		case 0:
			(*enginesIT).Protocol = XBoard;
			break;
		case 1:
			(*enginesIT).Protocol = UCI;
			break;
		default:
			break;
	}
	enableButtonApply( FALSE );
}
///////////////////////////////////////
//
//	dlg_engine::slotCancel
//
///////////////////////////////////////
void dlg_engine::slotCancel( void )
{
	slotDelayedDestruct();
}
///////////////////////////////////////
//
//	dlg_engine::slotFilenameDialog
//
///////////////////////////////////////
void dlg_engine::slotFilenameDialog( void )
{
	TQString temp;
	int tmp;

	temp = KFileDialog::getOpenFileName(	TQString(),
																				TQString( "*" ),
																				this,
																				TQString( "Find Engine..." ) );
	if( temp.isEmpty() ) return;
	EDIT_Filename->setText( temp );
	if( EDIT_Name->text().isEmpty() )
	{
		tmp = temp.findRev( '/' );
		EDIT_Name->setText( temp.remove( 0, tmp + 1 ) );
	}
	enableButtonApply( TRUE );
}
///////////////////////////////////////
//
//	dlg_engine::slotLogFileDialog
//
///////////////////////////////////////
void dlg_engine::slotLogFileDialog( void )
{
	TQString temp;

	temp = KFileDialog::getOpenFileName(	TQString(),
																				TQString( "*" ),
																				this,
																				TQString( "Find Log..." ) );
	if( temp.isEmpty() ) return;
	EDIT_LogFile->setText( temp );
	enableButtonApply( TRUE );
}
///////////////////////////////////////
//
//	dlg_engine::slotProtocol
//
///////////////////////////////////////
void dlg_engine::slotProtocol( int Index )
{
	if(Index);	// No-op to stop compile warning.
	enableButtonApply( TRUE );
}

