/***************************************************************************
                  challenge_graph_view.cpp  -  description
                             -------------------
    begin                : Mon Jan 7 2002
    copyright            : (C) 2003 by Eric Faccer
    email                : e.faccer@qut.edu.au
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string>
#include <tqpoint.h>
#include <tqstring.h>

#include "challenge_graph_view.moc"

#include "challenge_graph.h"
#include "challenge_rectangle.h"

///////////////////////////////////////
//
//	Challenge_Graph_View::Constructor
//
///////////////////////////////////////
Challenge_Graph_View::Challenge_Graph_View(TQCanvas& c, TQWidget * parent,const char* name, WFlags f, TQLabel *qsb)
 : TQCanvasView(&c,parent,name,f), canvas(c), statusbar(qsb)
{
	setHScrollBarMode( TQScrollView::AlwaysOff );
	setVScrollBarMode( TQScrollView::AlwaysOff );

	if ( parent )
		parent->installEventFilter( this );
	TQScrollView::viewport()->setMouseTracking(true);
}
///////////////////////////////////////
//
//	Challenge_Graph_View::Destructor
//
///////////////////////////////////////
Challenge_Graph_View::~Challenge_Graph_View()
{
}
///////////////////////////////////////
//
//	Challenge_Graph_View::contentsMousePressEvent
//
///////////////////////////////////////
void Challenge_Graph_View::contentsMousePressEvent(TQMouseEvent* e)
{
	TQCanvasItemList l = canvas.collisions(e->pos());
	TQCanvasItemList::Iterator it = l.begin();
	for(; it != l.end(); ++it )
	{
		Challenge_Rectangle *cr = dynamic_cast<Challenge_Rectangle *>(*it);
		Challenge_Game *g = cr->getGame();
		if( e->button() == Qt::LeftButton )
			emit leftClick( g->id() );
		if( e->button() == Qt::RightButton )
			emit rightClick( g, e->globalPos() );
		return;
	}
	if( e->button() == Qt::RightButton )
		emit rightClick( NULL, e->globalPos() ); // We need to catch all right clicks
}
///////////////////////////////////////
//
//	Challenge_Graph_View::reset
//
///////////////////////////////////////
void Challenge_Graph_View::reset()
{
	TQCanvasItemList list = canvas.allItems();
	TQCanvasItemList::Iterator it = list.begin();
	for(; it != list.end(); ++it )
	{
		Challenge_Rectangle *cr = dynamic_cast<Challenge_Rectangle *>(*it);
		Challenge_Game *g = cr->getGame();
		delete g;
		if ( *it )
			delete *it;
	}
}
///////////////////////////////////////
//
//	Challenge_Graph_View::contentsMouseMoveEvent
//
///////////////////////////////////////
void Challenge_Graph_View::contentsMouseMoveEvent(TQMouseEvent* e)
{
	TQString match;
	TQCanvasItemList l = canvas.collisions(e->pos());
	TQCanvasItemList::Iterator it = l.begin();
	for(; it!=l.end(); ++it)
	{
		Challenge_Rectangle *cr = dynamic_cast<Challenge_Rectangle *>(*it);
		Challenge_Game *g = cr->getGame();

		match = i18n( " Name: %1 Rating: %2 Match Type: %3 %4 Base Time: %5 Increment: %6" )
								.arg( g->_player ).arg( g->rating() ).arg( g->_match_type ).arg( g->_is_rated )
								.arg( g->clock() ).arg( g->increment() );
		break;
	}
	statusbar->setText( match );
}

