"""
This template constructs an application with menus, toolbar and statusbar,
HOWEVER it is not recommended this template actually be used. It presents
the "KDE 1.0" method for constructing menus and toolbars - later versions
of KDE have introduced better (easier and more powerful) methods for
doing this job - see other menuapp*.py templates for these methods
"""


"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""


False = 0
True  = not False


import sys

from PyTQt.tqt import TQPopupMenu, SIGNAL

from tdecore import TDEApplication, TDECmdLineArgs, TDEAboutData, i18n, TDEStdAccel, TDEIcon, TDEIconLoader
from tdeui import TDEMainWindow, KMessageBox

TOOLBAR_NEW   = 1
TOOLBAR_OPEN  = 2
TOOLBAR_SAVE  = 3
TOOLBAR_CUT   = 4
TOOLBAR_COPY  = 5
TOOLBAR_PASTE = 6

STATUSBAR_LEFT   = 1
STATUSBAR_MIDDLE = 2
STATUSBAR_RIGHT  = 3

class MainWin (TDEMainWindow):
    def __init__ (self, *args):
        apply (TDEMainWindow.__init__, (self,) + args)

        self.initMenus ()
        self.initToolBar ()
        self.initStatusBar ()

    def initMenus (self):
        # Create a TQPopupMenu - all menus are "popup" menus

        fileMenu = TQPopupMenu (self)

        # This is the "simple" KDE-1.0 way. It is not suggested that this
        # template actually be used in an application, but it's
        # provided to show the underlying mechanics of menu construction
        # that KDE makes much easier with other methods (see other
        # menuapp*.py templates for usable examples)

        # All menu item strings are wrapped with i18n - this allows
        # internationalization

        # Predefined accelerators are in TDEStdAccel - these are
        # the standard accelerators. For custom accelerators, use
        # TDEAccel. All TDEStdAccel methods are static, so there is no
        # need to instantiate TDEStdAccel

        # "File" menu items
        fileMenu.insertItem (i18n ("New"), self.slotNew, TDEStdAccel.openNew ())
        fileMenu.insertItem (i18n ("Open"), self.slotOpen, TDEStdAccel.open ())
        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("Save"), self.slotSave, TDEStdAccel.save ())

        # TDEStdAccel doesn't have a standard accelerator for 'Save As',
        # so we omit it - insertItem uses the default value

        fileMenu.insertItem (i18n ("SaveAs"), self.slotSaveAs)

        # This inserts a line between groups of items in a menu

        fileMenu.insertSeparator ();

        # Note the "TDEStdAccel.print_" has a trailing underscore, unlike the
        # equivalent KDE method - the underscore is necessary to prevent a
        # clash with the Python keyword 'print'

        fileMenu.insertItem (i18n ("Print"), self.slotPrint, TDEStdAccel.print_ ())

        fileMenu.insertSeparator ();
        fileMenu.insertItem (i18n ("&Quit"), self.slotQuit, TDEStdAccel.quit ());

        # Put fileMenu (as the File menu) into the menu bar
        # 'menuBar' is a predefined object owned by TDEMainWindow

        self.menuBar ().insertItem (i18n ("&File"), fileMenu)


        editMenu = TQPopupMenu (self)

        # "Edit" menu items
        editMenu.insertItem (i18n ("Undo"), self.slotUndo, TDEStdAccel.undo ())
        editMenu.insertItem (i18n ("Redo"), self.slotRedo, TDEStdAccel.redo ())
        editMenu.insertSeparator ();
        editMenu.insertItem (i18n ("Cut"), self.slotCut, TDEStdAccel.cut ())
        editMenu.insertItem (i18n ("Copy"), self.slotCopy, TDEStdAccel.copy ())
        editMenu.insertItem (i18n ("Paste"), self.slotPaste, TDEStdAccel.paste ())
        editMenu.insertSeparator ();
        editMenu.insertItem (i18n ("Find"), self.slotFind, TDEStdAccel.find ())
        editMenu.insertItem (i18n ("Find Next"), self.slotFindNext, TDEStdAccel.findNext ())
        editMenu.insertItem (i18n ("Replace"), self.slotReplace, TDEStdAccel.replace ())

        # Put editMenu (as the Edit menu) into the menu bar

        self.menuBar ().insertItem (i18n ("&Edit"), editMenu)

        # Let KDE generate a nifty help menu

        # The TDEAboutData/TDECmdLineArgs data from the main part of the program
        # will be used to generate the About dialog

        helpMenu = self.helpMenu ("")
        self.menuBar ().insertItem (i18n ("&Help"), helpMenu)

    def initToolBar (self):
        # TDEIconLoader will make it easy to locate the standard KDE icons for
        # toolbar buttons. For custom icons, a complete path to the icon
        # (without the loadIcon call) is needed
        icons = TDEIconLoader ()

        # TDEMainWindow owns at least one TDEToolBar instance, which is returned
        # by 'self.toolBar ()'. To obtain additional toolbars, add an argument
        # to the call -- self.toolBar (1) will return another toolbar you can
        # add buttons to.

        # Add buttons to the toolbar. The icon name, id value (eg TOOLBAR_NEW),
        # signal to connect (eg clicked) and the slot to connect to all need
        # to be specified,as does the tooltip (the last string argument). There
        # are easier ways to do this - see other menuapp templates for easier
        # methods using TDEAction/KStdAction

        self.toolBar ().insertButton (icons.loadIcon ("filenew", TDEIcon.Toolbar), TOOLBAR_NEW, SIGNAL ("clicked (int)"), self.slotNew,\
                                                       True, "New")
        self.toolBar ().insertButton (icons.loadIcon ("fileopen", TDEIcon.Toolbar), TOOLBAR_OPEN, SIGNAL ("clicked (int)"), self.slotOpen,\
                                                       True, "Open")
        self.toolBar ().insertButton (icons.loadIcon ("filesave", TDEIcon.Toolbar), TOOLBAR_SAVE, SIGNAL ("clicked (int)"), self.slotSave,\
                                                       True, "Save")
        self.toolBar ().insertButton (icons.loadIcon ("editcut", TDEIcon.Toolbar), TOOLBAR_CUT, SIGNAL ("clicked (int)"), self.slotCut,\
                                                       True, "Cut")
        self.toolBar ().insertButton (icons.loadIcon ("editcopy", TDEIcon.Toolbar), TOOLBAR_COPY, SIGNAL ("clicked (int)"), self.slotCopy,\
                                                       True, "Copy")
        self.toolBar ().insertButton (icons.loadIcon ("editpaste", TDEIcon.Toolbar), TOOLBAR_PASTE, SIGNAL ("clicked (int)"), self.slotPaste,\
                                                       True, "Paste")

    def initStatusBar (self):
        # TDEMainWindow also owns a KStatusBar instance. The first
        # call creates a KStatusBar instance. See 'notImpl' below
        # for an example of writing to the status bar. You can
        # also add widgets (labels, progress bars, etc) to the
        # status bar

        self.statusBar ().insertItem ("", STATUSBAR_LEFT, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_MIDDLE, 1000, True)
        self.statusBar ().insertItem ("", STATUSBAR_RIGHT, 1000, True)


#-------------------- slots -----------------------------------------------

    # Slots which can be called from both the menu toolbar
    # have a second parameter with a default value (id = -1)
    # This is because menu signals expect to connect to a
    # slot that takes no arguments, while toolbar signals
    # expect to send a signal with an int argument for the
    # id of the toolbar button. The default value allows
    # both cases to work.

    def slotNew (self, id = -1):
        self.notImpl ("New")

    def slotOpen(self, id = -1):
        self.notImpl ("Open")

    def slotSave (self, id = -1):
        self.notImpl ("Save")

    def slotSaveAs (self):
        self.notImpl ("Save As")

    def slotPrint (self):
        self.notImpl ("Print")

    def slotQuit (self):
        self.notImpl ("Quit")

    def slotUndo (self):
        self.notImpl ("Undo")

    def slotRedo (self):
        self.notImpl ("Redo")

    def slotCut (self, id = -1):
        self.notImpl ("Cut")

    def slotCopy (self, id = -1):
        self.notImpl ("Copy")

    def slotPaste (self, id = -1):
        self.notImpl ("Paste")

    def slotFind (self):
        self.notImpl ("Find")

    def slotFindNext (self):
        self.notImpl ("Find Next")

    def slotReplace (self):
        self.notImpl ("Replace")

    def notImpl (self, item = "Feature"):
        self.statusBar ().changeItem ("%s not implemented" % item, STATUSBAR_LEFT)
        KMessageBox.error (self, "%s not implemented" % item, "Not Implemented")
        self.statusBar ().changeItem ("", STATUSBAR_LEFT)


#-------------------- main ------------------------------------------------

# See athe minimal.py and basicapp.py templates for
# explantion of the basic app and main window setup

# The following data is passed to TDECmdLineArgs, which in
# turn makes it available to the "about" box in the Help
# menu (when the Help menu is created as above)

description = "A basic application template"
version     = "1.0"
aboutData   = TDEAboutData ("", "",\
    version, description, TDEAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

TDECmdLineArgs.init (sys.argv, aboutData)

TDECmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app = TDEApplication ()
mainWindow = MainWin (None, "main window")
mainWindow.show()
app.exec_loop()
