
from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQTimer, SIGNAL, TQFont, TQString
from tdecore import i18n
from tdeui import KPushButton, TDEFontDialog, KTextEdit

iconName = 'fonts'
labelText = 'TDEFontDialog'
docParts = ('tdeui', 'TDEFontDialog')
helpText = ("TDE provides a font dialog box for users to select (can you "
            "guess??) fonts.  The button below displays a font dialog box.  "
            "The font of this widget (the text widget you're reading) is used "
            "as the default.  If the dialog is accepted, the font of this "
            "widget is change to match the selection.")


fontText = """Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Etiam
ante. Nam in mauris. Vestibulum ante velit, condimentum vel, congue
sit amet, lobortis a, dui. Fusce auctor, quam non pretium nonummy, leo
ante imperdiet libero, id lobortis erat erat quis eros. Pellentesque
habitant morbi tristique senectus et netus et malesuada fames ac
turpis egestas. Cras ut metus. Vivamus suscipit, sapien id tempor
elementum, nunc quam malesuada dolor, sit amet luctus sapien odio vel
ligula. Integer scelerisque, risus a interdum vestibulum, felis ipsum
pharetra eros, nec nonummy libero justo quis risus. Vestibulum
tincidunt, augue vitae suscipit congue, sem dui adipiscing nulla, ut
nonummy arcu quam ac sem. Nulla in metus. Phasellus neque.
"""


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Font Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        self.example = KTextEdit(fontText, '', self)
        
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addWidget(self.example, 10)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showFontDialog)


    def showFontDialog(self):
        font = TQFont(self.example.font())
        string = TQString()
        accepted, other = TDEFontDialog.getFontAndText(font, string, False, self)
        if accepted:
            self.example.setFont(font)
            self.example.setText(string)
