
from PyTQt.tqt import TQFrame, TQHBoxLayout, TQVBoxLayout, TQTimer, SIGNAL, TQString
from tdecore import i18n, TDEConfigSkeleton
from tdeui import KPushButton, TDEConfigDialog, KTextEdit

iconName = 'configure'
labelText = 'TDEConfigDialog'
docParts = ('tdeui', 'TDEConfigDialog')
helpText = ("")


class SampleSettings(TDEConfigSkeleton):
    def __init__(self):
        TDEConfigSkeleton.__init__(self)
        self.anyString = TQString()

        self.setCurrentGroup("Strings")
        self.addItemString("Test", self.anyString, "Default Value")

        self.setCurrentGroup("Booleans")
        self.addItemBool("Any Bool", False)


class MainFrame(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.button = KPushButton(i18n('Show Config Dialog'), self)
        self.help = KTextEdit(helpText, '', self)
        
        layout = TQVBoxLayout(self, 4)
        layout.addWidget(self.help)
        buttonlayout = TQHBoxLayout(layout, 4)
        buttonlayout.addWidget(self.button)
        buttonlayout.addStretch(1)
        layout.addStretch(1)
        self.connect(self.button, SIGNAL('clicked()'), self.showConfigDialog)


    def showConfigDialog(self):
        config = SampleSettings()
        dlg = TDEConfigDialog(self, 'Sampler Config', config)
        self.strings = StringsSettings(self)
        self.bools = BoolSettings(self)
        dlg.addPage(self.strings, 'Strings', 'Strings')
        dlg.addPage(self.bools, 'Bools', 'Bools')        
        dlg.exec_loop()


class StringsSettings(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.text = KTextEdit('A String', '', self)


class BoolSettings(TQFrame):
    def __init__(self, parent=None):
        TQFrame.__init__(self, parent)
        self.text = KTextEdit('A Bool', '', self)
            
