/***************************************************************************
                          processexec.cpp  -  description
                             -------------------
    begin                : sb abr 27 2002
    copyright            : (C) 2002 by asdf
    email                : dsf
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <string.h>
#include "processexec.h"

ProcessExec::ProcessExec(): TDEProcess()
{
 clearData();
 connect( this, SIGNAL(receivedStdout(TDEProcess *, char *, int)),this, SLOT(slotReceivedStdout(TDEProcess *, char *, int)) );
 connect( this, SIGNAL(receivedStderr(TDEProcess *, char *, int)),this, SLOT(slotReceivedStderr(TDEProcess *, char *, int)) );
}

ProcessExec::~ProcessExec(){
}

bool ProcessExec::run()
{
 clearData();
 return start( NotifyOnExit, Communication(Stdout | Stderr )); // | NoRead));
}

bool ProcessExec::runAndWait()
{
 clearData();
 return start(Block,Communication(Stdout | Stderr));
}

void ProcessExec::slotReceivedStdout(TDEProcess *proc, char *buf, int len)
{
  buffer = TQString(buf);
}

void ProcessExec::slotReceivedStderr(TDEProcess *proc, char *buf, int len)
{
 fErrors= true;
 slotReceivedStdout(proc,buf,len);
}

#include "processexec.moc"
