/***************************************************************************
                          kmymoneylineedit.cpp  -  description
                             -------------------
    begin                : Wed May 9 2001
    copyright            : (C) 2001 by Michael Edwardes
    email                : mte@users.sourceforge.net
                             Javier Campos Morales <javi_c@ctv.es>
                             Felix Rodriguez <frodriguez@mail.wesleyan.edu>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

#include <tqrect.h>
#include <tqpainter.h>
#include <tqpalette.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdeglobal.h>
#include <tdelocale.h>

// ----------------------------------------------------------------------------
// Project Includes

#include "kmymoneylineedit.h"

kMyMoneyLineEdit::kMyMoneyLineEdit(TQWidget *w, const char* name, bool forceMonetaryDecimalSymbol, int alignment) :
  KLineEdit(w, name),
  m_forceMonetaryDecimalSymbol(forceMonetaryDecimalSymbol)
{
  setAlignment(alignment);
}

kMyMoneyLineEdit::~kMyMoneyLineEdit()
{
}

void kMyMoneyLineEdit::resetText(void)
{
  setText(m_text);
}

void kMyMoneyLineEdit::loadText(const TQString& text)
{
  m_text = text;
  setText(text);
}

void kMyMoneyLineEdit::focusOutEvent(TQFocusEvent *ev)
{
  // if the current text is not in the list of
  // possible completions, we have a new payee
  // and signal that to the outside world.
  if(text() != m_text) {
    emit lineChanged(text());
  }
  KLineEdit::focusOutEvent(ev);

  // force update of hint
  if(text().isEmpty())
    repaint();
}

void kMyMoneyLineEdit::keyReleaseEvent(TQKeyEvent* k)
{
  if(m_forceMonetaryDecimalSymbol) {
    if(k->state() & TQt::Keypad) {
      if(k->key() == TQt::Key_Comma
      || k->key() == TQt::Key_Period) {
        if(TDEGlobal::locale()->monetaryDecimalSymbol() == ",") {
          TQKeyEvent newk(k->type(), TQt::Key_Comma, ',', k->state(), ",", k->isAutoRepeat(), k->count());
          KLineEdit::keyReleaseEvent(&newk);
          k->ignore();
          return;
        }

        if(TDEGlobal::locale()->monetaryDecimalSymbol() == ".") {
          TQKeyEvent newk(k->type(), TQt::Key_Comma, ',', k->state(), ".", k->isAutoRepeat(), k->count());
          KLineEdit::keyReleaseEvent(&newk);
          k->ignore();
          return;
        }
      }
    }
  }
  KLineEdit::keyReleaseEvent(k);
}

void kMyMoneyLineEdit::keyPressEvent(TQKeyEvent* k)
{
  if(m_forceMonetaryDecimalSymbol) {
    if(k->state() & TQt::Keypad) {
      if(k->key() == TQt::Key_Comma
      || k->key() == TQt::Key_Period) {
        if(TDEGlobal::locale()->monetaryDecimalSymbol() == ",") {
          TQKeyEvent newk(k->type(), TQt::Key_Comma, ',', k->state(), ",", k->isAutoRepeat(), k->count());
          KLineEdit::keyPressEvent(&newk);
          k->ignore();
          return;
        }

        if(TDEGlobal::locale()->monetaryDecimalSymbol() == ".") {
          TQKeyEvent newk(k->type(), TQt::Key_Period, '.', k->state(), ".", k->isAutoRepeat(), k->count());
          KLineEdit::keyPressEvent(&newk);
          k->ignore();
          return;
        }
      }
    }
  }
  KLineEdit::keyPressEvent(k);
}

void kMyMoneyLineEdit::drawContents( TQPainter *p)
{
  KLineEdit::drawContents(p);

  if(text().isEmpty() && !m_hint.isEmpty() && !hasFocus()) {
    const int innerMargin = 1;

    // the following 5 lines are taken from TQLineEdit::drawContents()
    TQRect cr = contentsRect();
    TQFontMetrics fm = fontMetrics();
    TQRect lineRect( cr.x() + innerMargin, cr.y() + (cr.height() - fm.height() + 1) / 2,
                    cr.width() - 2*innerMargin, fm.height() );
    TQPoint topLeft = lineRect.topLeft() - TQPoint(0, -fm.ascent());

    p->save();
    TQFont f = p->font();
    f.setItalic(true);
    f.setWeight(TQFont::Light);
    p->setFont(f);
    p->setPen(palette().disabled().text());

    p->drawText(topLeft, m_hint);

    p->restore();
  }
}

#include "kmymoneylineedit.moc"
