/***************************************************************************
                          kmymoneyforecastlistviewitem.h
                             -------------------
    begin                : Sun Nov 25 2007
    copyright            : (C) 2007 by Alvaro Soliverez
    email                : asoliverez@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYMONEYFORECASTLISTVIEWITEM_H
#define KMYMONEYFORECASTLISTVIEWITEM_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqobject.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdelistview.h>

// ----------------------------------------------------------------------------
// Project Includes

/**
  * This class implements a derived version of a TDEListViewItem that
  * allows printing negative numbers in red
  *
  * @author Alvaro Soliverez
  */
class KMyMoneyForecastListViewItem : public TDEListViewItem
{
public:
  
  KMyMoneyForecastListViewItem(TQListView* parent, TQListViewItem* after, bool isNegative);
  
  ~KMyMoneyForecastListViewItem();
  
  void setNegative(bool isNegative);
  
  void setText( int column, const TQString &text, const bool &negative = false );

  /**
    * use my own paint method
    */
  void paintCell(TQPainter *p, const TQColorGroup &cg, int column, int width, int alignment);


private:
  
  bool m_negative;
  
  TQMap<int, TQColor> m_columnsColor;
};

#endif
