/***************************************************************************
                          viewinterface.cpp
                             -------------------
    begin                : Wed Jan 5 2005
    copyright            : (C) 2005 Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

// ----------------------------------------------------------------------------
// KDE Includes

// ----------------------------------------------------------------------------
// Project Includes

#include "../../kmymoney2.h"
#include "../../views/kmymoneyview.h"
#include "../../widgets/selectedtransaction.h"
#include "kmmviewinterface.h"

KMyMoneyPlugin::KMMViewInterface::KMMViewInterface(KMyMoney2App* app, KMyMoneyView* view, TQObject* parent, const char* name) :
  ViewInterface(parent, name),
  m_app(app),
  m_view(view)
{
  connect(app, TQT_SIGNAL(accountSelected(const MyMoneyAccount&)), this, TQT_SIGNAL(accountSelected(const MyMoneyAccount&)));
  connect(app, TQT_SIGNAL(transactionsSelected(const KMyMoneyRegister::SelectedTransactions&)), this, TQT_SIGNAL(transactionsSelected(const KMyMoneyRegister::SelectedTransactions&)));
  connect(app, TQT_SIGNAL(accountReconciled(const MyMoneyAccount&, const TQDate&, const MyMoneyMoney&, const MyMoneyMoney&, const TQValueList<TQPair<MyMoneyTransaction, MyMoneySplit> >&)),
          this, TQT_SIGNAL(accountReconciled(const MyMoneyAccount&, const TQDate&, const MyMoneyMoney&, const MyMoneyMoney&, const TQValueList<TQPair<MyMoneyTransaction, MyMoneySplit> >&)));

  connect(app, TQT_SIGNAL(institutionSelected(const MyMoneyInstitution&)), this, TQT_SIGNAL(institutionSelected(const MyMoneyInstitution&)));

  connect(m_view, TQT_SIGNAL(viewStateChanged(bool)), this, TQT_SIGNAL(viewStateChanged(bool)));
  connect(m_view, TQT_SIGNAL(kmmFilePlugin(unsigned int)), this, TQT_SIGNAL(kmmFilePlugin(unsigned int)));
}

KMyMoneyViewBase* KMyMoneyPlugin::KMMViewInterface::addPage(const TQString& item, const TQString& icon)
{
  return m_view->addPage(item, icon);
}

void KMyMoneyPlugin::KMMViewInterface::addWidget(KMyMoneyViewBase* view, TQWidget* w)
{
  if(view && w)
    view->addWidget(w);
}


#include "kmmviewinterface.moc"
