/***************************************************************************
                          kmymoneyglobalsettings.cpp
                             -------------------
    copyright            : (C) 2006 by Thomas Baumgart
    email                : ipwizard@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// ----------------------------------------------------------------------------
// QT Includes

#include <tqregexp.h>

// ----------------------------------------------------------------------------
// KDE Includes

#include <tdeglobalsettings.h>

// ----------------------------------------------------------------------------
// Project Includes

#include <kmymoney/kmymoneyglobalsettings.h>

TQFont KMyMoneyGlobalSettings::listCellFont(void)
{
  if(useSystemFont()) {
    return TDEGlobalSettings::generalFont();
  } else {
    return KMyMoneySettings::listCellFont();
  }
}

TQFont KMyMoneyGlobalSettings::listHeaderFont(void)
{
  if(useSystemFont()) {
    TQFont font = TDEGlobalSettings::generalFont();
    font.setBold(true);
    return font;
  } else {
    return KMyMoneySettings::listHeaderFont();
  }
}

TQColor KMyMoneyGlobalSettings::listColor(void)
{
  if(useSystemColors())
    return TDEGlobalSettings::baseColor();
  else
    return KMyMoneySettings::listColor();
}

TQColor KMyMoneyGlobalSettings::listBGColor(void)
{
  if(useSystemColors())
    return TDEGlobalSettings::alternateBackgroundColor();
  else
    return KMyMoneySettings::listBGColor();
}

TQStringList KMyMoneyGlobalSettings::itemList(void)
{
  bool prevValue = self()->useDefaults(true);
  TQStringList all = TQStringList::split(",", KMyMoneySettings::itemList());
  self()->useDefaults(prevValue);
  TQStringList list = TQStringList::split(",", KMyMoneySettings::itemList());

  // now add all from 'all' that are missing in 'list'
  TQRegExp exp("-?(\\d+)");
  TQStringList::iterator it_s;
  for(it_s = all.begin(); it_s != all.end(); ++it_s) {
    exp.search(*it_s);
    if(!list.contains(exp.cap(1)) && !list.contains(TQString("-%1").arg(exp.cap(1)))) {
      list << *it_s;
    }
  }
  return list;
}

int KMyMoneyGlobalSettings::firstFiscalMonth(void)
{
  return KMyMoneySettings::fiscalYearBegin()+1;
}

int KMyMoneyGlobalSettings::firstFiscalDay(void)
{
  return KMyMoneySettings::fiscalYearBeginDay();
}

