/***************************************************************************
                          kmymoneysplittable.h  -  description
                             -------------------
    begin                : Thu Jan 10 2002
    copyright            : (C) 2000-2002 by Michael Edwardes
    email                : mte@users.sourceforge.net
                           Javier Campos Morales <javi_c@users.sourceforge.net>
                           Felix Rodriguez <frodriguez@users.sourceforge.net>
                           John C <thetacoturtle@users.sourceforge.net>
                           Thomas Baumgart <ipwizard@users.sourceforge.net>
                           Kevin Tambascio <ktambascio@users.sourceforge.net>
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KMYMONEYSPLITTABLE_H
#define KMYMONEYSPLITTABLE_H

// ----------------------------------------------------------------------------
// QT Includes

#include <tqwidget.h>
#include <tqtable.h>
#include <tqwidgetlist.h>
#include <tqguardedptr.h>

// ----------------------------------------------------------------------------
// KDE Includes

class TDEPopupMenu;
class KPushButton;

// ----------------------------------------------------------------------------
// Project Includes

#include "../mymoney/mymoneytransaction.h"
#include "../mymoney/mymoneyaccount.h"

class KMyMoneyCategory;
class kMyMoneyLineEdit;
class kMyMoneyEdit;

/**
  * @author Thomas Baumgart
  */
class kMyMoneySplitTable : public TQTable
{
  TQ_OBJECT
  
public:
  kMyMoneySplitTable(TQWidget *parent=0, const char *name=0);
  virtual ~kMyMoneySplitTable();

  void paintCell(TQPainter *p, int row, int col, const TQRect& r, bool /*selected*/);
  void paintFocus(TQPainter *p, const TQRect &cr);

  /**
    * This method is used to load the widget with the information about
    * the transaction @p t. The split referencing the account @p acc is
    * not shown in the widget.
    *
    * @param t reference to transaction to be shown/modified
    * @param s reference to split that is to be hidden
    * @param acc reference to account
    */
  void setTransaction(const MyMoneyTransaction& t, const MyMoneySplit& s, const MyMoneyAccount& acc);

  /**
    * This method is used to retrieve the transaction from the widget.
    */
  const MyMoneyTransaction& transaction(void) const { return m_transaction; }

  /**
    * Returns a list of MyMoneySplit objects. It contains all but the one
    * referencing the account passed in setTransaction().
    *
    * @param t reference to transaction
    * @return list of splits
    */
  const TQValueList<MyMoneySplit> getSplits(const MyMoneyTransaction& t) const;

  void setup(const TQMap<TQString, MyMoneyMoney>& priceInfo);

protected:
  void contentsMousePressEvent( TQMouseEvent* e );
  void contentsMouseReleaseEvent( TQMouseEvent* e );
  void contentsMouseDoubleClickEvent( TQMouseEvent* e );
  bool eventFilter(TQObject *o, TQEvent *e);
  void endEdit(int row, int col, bool accept, bool replace );

  void resizeEvent(TQResizeEvent*);
  TQWidget* createEditWidgets(void);
  void destroyEditWidgets(void);

  /**
    * This method handles the focus of the keyboard. When in edit mode
    * (m_editCategory widget is visible) the keyboard focus is handled
    * according to the widgets that are referenced in m_tabOrderWidgets.
    * If not in edit mode, the base class functionality is provided.
    *
    * @param next true if forward-tab, false if backward-tab was
    *             pressed by the user
    */
  virtual bool focusNextPrevChild(bool next);
  void addToTabOrder(TQWidget* w);

  /**
    * convenience function for setCurrentCell(int row, int col)
    */
  void setCurrentCell(int row) { setCurrentCell(row, 0); }

  void updateTransactionTableSize(void);

  /**
    * This method returns the current state of the inline editing mode
    *
    * @return true if inline edit mode is on, false otherwise
    */
  bool isEditMode(void) const;

  /**
    * This method retuns the background color for a given @p row.
    *
    * @param row the row in question
    * @return the color as TQColor object
    */
  const TQColor rowBackgroundColor(const int row) const;

  void endEdit(bool keyboardDriven);

public slots:
  /** No descriptions */
  virtual void setCurrentCell(int row, int col);

  virtual void setNumRows(int r);

  TQWidget* slotStartEdit(void);
  void slotEndEdit(void);
  void slotEndEditKeyboard(void);
  void slotDeleteSplit(void);
  void slotCancelEdit(void);
  void slotDuplicateSplit(void);

protected slots:
  virtual void columnWidthChanged(int col);

  /// move the focus to the selected @p row.
  void slotSetFocus(int row, int col = 0, int button = Qt::LeftButton, const TQPoint & mousePos = TQPoint(0, 0));

  /**
    * Calling this slot refills the widget with the data
    * passed in the argument @p t.
    *
    * @param t reference to transaction data
    */
  void slotUpdateData(const MyMoneyTransaction& t);

  void slotLoadEditWidgets(void);

signals:
  /**
    * This signal is emitted whenever the return key is pressed
    * and the widget is not in edit mode.
    */
  void escapePressed(void);

  /**
    * This signal is emitted whenever the return key is pressed
    * and the widget is not in edit mode.
    */
  void returnPressed(void);

  /**
    * This signal is emitted whenever the transaction data has been changed
    *
    * @param t modified transaction data
    */
  void transactionChanged(const MyMoneyTransaction& t);

  /**
    * This signal is sent out, when a new category needs to be created
    * @sa KMyMoneyCombo::createItem()
    *
    * @param txt The name of the category to be created
    * @param id A connected slot should store the id of the created object in this variable
    */
  void createCategory(const TQString& txt, TQString& id);

  /**
    * Signal is emitted, if any of the widgets enters (@a state equals @a true)
    *  or leaves (@a state equals @a false) object creation mode.
    *
    * @param state Enter (@a true) or leave (@a false) object creation
    */
  void objectCreation(bool state);

private:
  /// the currently selected row (will be printed as selected)
  int                 m_currentRow;

  /// the number of rows filled with data
  int                 m_maxRows;

  /// indication if inline editing mode is on or not
  bool                m_editMode;

  MyMoneyTransaction  m_transaction;
  MyMoneyAccount      m_account;
  MyMoneySplit        m_split;
  MyMoneySplit        m_hiddenSplit;

  unsigned            m_amountWidth;

  /**
    * This member keeps a pointer to the context menu
    */
  TDEPopupMenu*         m_contextMenu;

  /// keeps the id of the delete entry in the context menu
  int                 m_contextMenuDelete;

  /// keeps the id of the duplicate entry in the context menu
  int                 m_contextMenuDuplicate;

  /**
    * This member contains a pointer to the input widget for the category.
    * The widget will be created and destroyed dynamically in createInputWidgets()
    * and destroyInputWidgets().
    */
  TQGuardedPtr<KMyMoneyCategory> m_editCategory;

  /**
    * This member contains a pointer to the input widget for the memo.
    * The widget will be created and destroyed dynamically in createInputWidgets()
    * and destroyInputWidgets().
    */
  TQGuardedPtr<kMyMoneyLineEdit> m_editMemo;

  /**
    * This member contains a pointer to the input widget for the amount.
    * The widget will be created and destroyed dynamically in createInputWidgets()
    * and destroyInputWidgets().
    */
  TQGuardedPtr<kMyMoneyEdit>     m_editAmount;

  /**
    * This member keeps the tab order for the above widgets
    */
  TQWidgetList         m_tabOrderWidgets;

  TQGuardedPtr<TQFrame>           m_registerButtonFrame;
  TQGuardedPtr<KPushButton>      m_registerEnterButton;
  TQGuardedPtr<KPushButton>      m_registerCancelButton;

  TQMap<TQString, MyMoneyMoney>  m_priceInfo;
};

#endif
