#include "src/svnqt/client.h"
#include "src/svnqt/tests/testconfig.h"
#include "src/svnqt/repository.h"
#include "src/svnqt/repositorylistener.h"
#include "src/svnqt/targets.h"

#include "testlistener.h"

#include <iostream>
#include <unistd.h>
#include <tqstringlist.h>

class Listener:public svn::repository::RepositoryListener
{
    public:
        Listener(){}
        virtual ~Listener(){}
        virtual void sendWarning(const TQString&msg)
        {
            std::cout << msg << std::endl;
        }
        virtual void sendError(const TQString&msg)
        {
            std::cout << msg << std::endl;
        }
        virtual bool isCanceld(){return false;}
};

int main(int,char**)
{
    TQString p = TESTREPOPATH;
    Listener ls;
    svn::repository::Repository rp(&ls);
    try {
        rp.CreateOpen(p,"fsfs");
    } catch (svn::ClientException e) {
        TQString ex = e.msg();
        std::cout << ex.TOUTF8() << std::endl;
        return -1;
    }

    svn::ContextP m_CurrentContext;
    svn::Client* m_Svnclient;
    m_Svnclient=svn::Client::getobject(0,0);
    TestListener tl;
    m_CurrentContext = new svn::Context();
    m_CurrentContext->setListener(&tl);
    p = "file://"+p;

    m_Svnclient->setContext(m_CurrentContext);
    TQStringList s; s.append(p+"/trunk"); s.append(p+"/branches"); s.append(p+"/tags");

    try {
        m_Svnclient->mkdir(svn::Targets(s),"Test mkdir");
        m_Svnclient->checkout(p,TESTCOPATH,svn::Revision::HEAD,svn::Revision::HEAD,svn::DepthInfinity,false);
    } catch (svn::ClientException e) {
        TQString ex = e.msg();
        std::cout << ex.TOUTF8() << std::endl;
        return -1;
    }

    return 0;
}
