#!/usr/bin/perl -w
use strict;
use blib;

package MyWidget;
use TQt;
use TQt::isa qw(TQt::VBox);

use LCDRange;

sub NEW {
    shift->SUPER::NEW(@_);

    my $quit = TQt::PushButton("Quit", this, "quit");
    $quit->setFont(TQt::Font("Times", 18, &TQt::Font::Bold));

    TQt::app->connect($quit, TQT_SIGNAL('clicked()'), TQT_SLOT('quit()'));

    my $grid = TQt::Grid(4, this);

    my $previous;
    for my $r (0..3) {
	for my $c (0..3) {
	    my $lr = LCDRange($grid);
	    $previous->connect(
		$lr, TQT_SIGNAL('valueChanged(int)'),
		TQT_SLOT('setValue(int)')) if $previous;
	    $previous = $lr;
	}
    }
}

package main;
use MyWidget;

my $a = TQt::Application(\@ARGV);
my $w = MyWidget;
$a->setMainWidget($w);
$w->show;
exit $a->exec;
