/***************************************************************************
 *   Copyright (C) 2005 by Niklas Knutsson                                 *
 *   nq@altern.org                                                         *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef QALCULATECONVERTNUMBERBASESDIALOG_H
#define QALCULATECONVERTNUMBERBASESDIALOG_H

#include <kdialogbase.h>

class KLineEdit;
class MathStructure;

/**
@author Niklas Knutsson
*/
class QalculateConvertNumberBasesDialog : public KDialogBase {
	TQ_OBJECT
public:
	QalculateConvertNumberBasesDialog(TQWidget *parent = 0, const char *name = 0);

	virtual ~QalculateConvertNumberBasesDialog();

	KLineEdit *binaryEdit, *octalEdit, *decimalEdit, *hexadecimalEdit;

public slots:

	void setDecimalValue(const TQString&);
	void setBinaryValue(const TQString&);
	void setOctalValue(const TQString&);
	void setHexadecimalValue(const TQString&);

protected:

	void updateEntries(const MathStructure *value, int base);

};

#endif
