/***************************************************************************
*   Copyright (C) 2004-2009 by Thomas Fischer                             *
*   fischer@unix-ag.uni-kl.de                                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

#include <tqlayout.h>

#include <tdelocale.h>
#include <kiconloader.h>

#include "settingsfileio.h"
#include "settingsediting.h"
#include "settingssearchurl.h"
#include "settingsidsuggestions.h"
#include "settingskeyword.h"
#include "settingsuserdefinedinput.h"
#ifdef HAVE_YAZ
#include "settingsz3950.h"
#endif // HAVE_YAZ
#include "settingsdlg.h"

namespace KBibTeX
{
    SettingsDlg::SettingsDlg( TQWidget *parent, const char *name )
            : KDialogBase( Tabbed, i18n( "Configure" ), Ok | Apply | Cancel, Ok, parent, name, true )
    {
        TQFrame * page = addPage( i18n( "&Editing" ) );
        TQVBoxLayout *layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_editing = new SettingsEditing( page );
        layout->addWidget( m_editing );
        connect( m_editing, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );

        page = addPage( i18n( "&File Open&&Save" ) );
        layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_fileIO = new SettingsFileIO( page );
        layout->addWidget( m_fileIO );
        connect( m_fileIO, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );

        page = addPage( i18n( "&Search URLs" ) );
        layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_searchURL = new SettingsSearchURL( page );
        layout->addWidget( m_searchURL );
        connect( m_searchURL, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );

        page = addPage( i18n( "Global &Keywords" ), TQString::null, SmallIcon( "package" ) );
        layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_keyword = new SettingsKeyword( page );
        layout->addWidget( m_keyword );
        connect( m_keyword, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );

        page = addPage( i18n( "Id Suggestions" ) );
        layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_idSuggestions = new SettingsIdSuggestions( page );
        layout->addWidget( m_idSuggestions );
        connect( m_idSuggestions, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );

        page = addPage( i18n( "User Defined Fields" ) );
        layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_userDefinedInput = new SettingsUserDefinedInput( page );
        layout->addWidget( m_userDefinedInput );
        connect( m_userDefinedInput, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );

#ifdef HAVE_YAZ
        page = addPage( i18n( "Z39.50" ) );
        layout = new TQVBoxLayout( page, 0, spacingHint() );
        m_z3950config = new SettingsZ3950( page );
        layout->addWidget( m_z3950config );
        connect( m_z3950config, SIGNAL( configChanged() ), this, SLOT( slotConfigChanged() ) );
#endif // HAVE_YAZ

        connect( this, SIGNAL( applyClicked() ), SLOT( slotApplySettings() ) );
    }


    SettingsDlg::~SettingsDlg()
    {
        // nothing
    }

    int SettingsDlg::exec()
    {
        m_fileIO->readData();
        m_editing->readData();
        m_searchURL->readData();
        m_keyword->readData();
        m_idSuggestions->readData();
        m_userDefinedInput->readData();
#ifdef HAVE_YAZ
        m_z3950config->readData();
#endif // HAVE_YAZ
        enableButton( Apply, FALSE );

        return KDialogBase::exec();
    }

    void SettingsDlg::slotConfigChanged()
    {
        enableButton( Apply, TRUE );
    }

    void SettingsDlg::slotApplySettings()
    {
        m_fileIO->applyData();
        m_editing->applyData();
        m_searchURL->applyData();
        m_keyword->applyData();
        m_idSuggestions->applyData();
        m_userDefinedInput->applyData();
#ifdef HAVE_YAZ
        m_z3950config->applyData();
#endif // HAVE_YAZ
        enableButton( Apply, FALSE );
    }

    void SettingsDlg::accept()
    {
        slotApplySettings();
        KDialogBase::accept();
    }
}

#include "settingsdlg.moc"
