//
//   File : helpwidget.cpp
//   Creation date : Thu Aug 10 2000 17:42:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//

#include "helpwidget.h"

#include "kvi_frame.h"
#include "kvi_iconmanager.h"
#include "kvi_locale.h"
#include "kvi_app.h"
#include "kvi_msgbox.h"
#include "kvi_module.h"
#include "kvi_styled_controls.h"
#include "helpwindow.h"
#include "kvi_fileutils.h"

#include <tqtoolbutton.h>
#include <tqlineedit.h>
#include <tqtooltip.h>
#include <tqtimer.h>
#include <tqclipboard.h>

extern Index        * g_pDocIndex;
extern KviPointerList<KviHelpWindow> * g_pHelpWindowList;
extern KviPointerList<KviHelpWidget> * g_pHelpWidgetList;

KviHelpWidget::KviHelpWidget(TQWidget * par,KviFrame * lpFrm,bool bIsStandalone)
: TQWidget(par,"help_widget")
{

	if(bIsStandalone)g_pHelpWidgetList->append(this);
	m_bIsStandalone = bIsStandalone;

//#warning "Re enable this when using TQt 3.0 : TQProcess "
	m_pTextBrowser = new TQTextBrowser(this,"text_browser");
	m_pTextBrowser->setFrameStyle(TQFrame::StyledPanel|TQFrame::Sunken);
	m_pTextBrowser->setFocusPolicy(TQWidget::NoFocus);
	m_pToolBar = new KviTalHBox(this);

	m_pBtnIndex = new KviStyledToolButton(m_pToolBar);
	m_pBtnIndex->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPINDEX));
	connect(m_pBtnIndex,TQT_SIGNAL(clicked()),this,TQT_SLOT(showIndex()));
	//m_pBtnIndex->setUsesBigPixmap(true);

	m_pBtnBackward = new KviStyledToolButton(m_pToolBar);
	m_pBtnBackward->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPBACK));
	connect(m_pBtnBackward,TQT_SIGNAL(clicked()),m_pTextBrowser,TQT_SLOT(backward()));
	m_pBtnBackward->setEnabled(false);
	//m_pBtnBackward->setUsesBigPixmap(true);

	m_pBtnForward = new KviStyledToolButton(m_pToolBar);
	m_pBtnForward->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPFORWARD));
	connect(m_pBtnForward,TQT_SIGNAL(clicked()),m_pTextBrowser,TQT_SLOT(forward()));
	m_pBtnForward->setEnabled(false);
	//m_pBtnForward->setUsesBigPixmap(true);
	
	TQWidget* pSpacer=new TQWidget(m_pToolBar);
	
	if(bIsStandalone)
	{
		TQToolButton * b = new KviStyledToolButton(m_pToolBar);
		b->setIconSet(*g_pIconManager->getBigIcon(KVI_BIGICON_HELPCLOSE));
		connect(b,TQT_SIGNAL(clicked()),this,TQT_SLOT(doClose()));
		//b->setUsesBigPixmap(true);
	}

	m_pToolBar->setStretchFactor(pSpacer,1);
	connect(m_pTextBrowser,TQT_SIGNAL(backwardAvailable(bool)),m_pBtnBackward,TQT_SLOT(setEnabled(bool)));
	connect(m_pTextBrowser,TQT_SIGNAL(forwardAvailable(bool)),m_pBtnForward,TQT_SLOT(setEnabled(bool)));

	m_pTextBrowser->viewport()->installEventFilter(this);

}

KviHelpWidget::~KviHelpWidget()
{
	if(m_bIsStandalone)g_pHelpWidgetList->removeRef(this);
}

void KviHelpWidget::showIndex()
{
	m_pTextBrowser->setSource("index.html");
}

void KviHelpWidget::resizeEvent(TQResizeEvent *e)
{
	int hght = m_pToolBar->sizeHint().height();
	if(hght < 40)hght = 40;
	m_pToolBar->setGeometry(0,0,width(),hght);
	m_pTextBrowser->setGeometry(0,hght,width(),height() - hght);
}

void KviHelpWidget::doClose()
{
	// hack needed to workaround "TQToolBar::emulateButtonClicked()"
	// that refers to the "this" pointer after this slot has been
	// called (from the "too-small-toolbar-for-all-items-popup")
	TQTimer::singleShot(0,this,TQT_SLOT(suicide()));
}

void KviHelpWidget::suicide()
{
	// goodbye cruel wolrd
	delete this;
}

TQSize KviHelpWidget::sizeHint() const
{
	int wdth = m_pTextBrowser->sizeHint().width();
	if(m_pToolBar->sizeHint().width() > wdth)wdth = m_pToolBar->sizeHint().width();
	TQSize s(wdth,m_pTextBrowser->sizeHint().height() + m_pToolBar->sizeHint().height());
	return s;
}

bool KviHelpWidget::eventFilter(TQObject * o, TQEvent *e)
{
	TQClipboard *cb = TQApplication::clipboard();
	
	if(e->type() == TQEvent::MouseButtonRelease) {
		if(m_pTextBrowser->hasSelectedText()) {
			cb->setText(m_pTextBrowser->selectedText());
		}
	}

	return TQWidget::eventFilter(o,e);
}



#include "helpwidget.moc"
