#ifndef _KVI_TOPICW_H_
#define _KVI_TOPICW_H_

//============================================================================
//
//   File : kvi_topicw.h
//   Creation date : Fri Aug 4 2000 12:03:12 by Szymon Stefanek
//
//   This file is part of the KVirc irc client distribution
//   Copyright (C) 2000-2004 Szymon Stefanek (pragma at kvirc dot net)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//============================================================================

#include "kvi_settings.h"

#include <tqframe.h>
#include <tqpushbutton.h>
#include "kvi_tal_listbox.h" 

#include "kvi_string.h"
#include "kvi_app.h"
#include "kvi_input.h"

class TQComboBox;
class KviChannel;
class KviTalPopupMenu;
class KviIrcConnection;
class KviTalListBox;

class KVIRC_API KviListBoxTopicItem : public KviTalListBoxText
{
public:
	KviListBoxTopicItem( KviTalListBox * listbox = 0 , const TQString & text = TQString()):KviTalListBoxText(listbox,text) { ; };
	virtual int width ( const KviTalListBox * lb ) const;
protected:
	virtual void paint ( TQPainter * p );

};

class KVIRC_API KviTopicWidget : public TQFrame 
{
	TQ_OBJECT
  
	TQ_PROPERTY(int TransparencyCapable READ dummyRead)
	friend class KviChannel;
	
public:
	KviTopicWidget(TQWidget * par,const char * name);
	~KviTopicWidget();

private:
	TQString       m_szTopic;
	TQString       m_szSetBy;
	TQString       m_szSetAt;
	TQPushButton * m_pAccept;
	TQPushButton * m_pDiscard;
	TQPushButton * m_pHistory;
	KviTalPopupMenu  * m_pContextPopup;
	TQChar getSubstituteChar(unsigned short control_code);
	int xCursorPostionCalculation(int xInd);
	KviInputEditor* m_pInput;
	KviTalListBox* 	m_pCompletionBox;
protected:
	int  m_iCursorPosition;
	virtual void drawContents(TQPainter *p);
	virtual void mouseDoubleClickEvent(TQMouseEvent *e);
	virtual void mousePressEvent(TQMouseEvent *e);
	virtual void keyPressEvent(TQKeyEvent *e);
	virtual void resizeEvent(TQResizeEvent *e);
	void updateToolTip();
	void deactivate();
	void iconButtonClicked();
	virtual bool eventFilter(TQObject *o,TQEvent *e);
	bool handleKeyPressEvent(TQKeyEvent * e);
public:
	void insertChar(TQChar c);
	void insertText(const TQString &s);
	int dummyRead() const { return 0; };
	void reset();

	void setTopic(const TQString & szTopic);
	void setTopicSetBy(const TQString & setBy);
	void setTopicSetAt(const TQString & setAt);

	const TQString & topic(){ return m_szTopic; };
	const TQString & topicSetBy(){ return m_szSetBy; };
	const TQString & topicSetAt(){ return m_szSetAt; };
	virtual TQSize sizeHint() const;
	void applyOptions();
	
	static void paintColoredText(TQPainter *p, TQString text,const TQColorGroup& cg, int h=-1, int w=-1);
protected slots:
	void acceptClicked();
	void discardClicked();
	void historyClicked();
	void contextPopupAboutToShow();
	void copy();
	void complete(int);
	void popDownListBox();
signals:
	void topicSelected(const TQString &szTopic);
};

#endif //_KVI_TOPICW_H_
