#ifndef _KVI_CUSTOMTOOLBARMANAGER_H_
#define _KVI_CUSTOMTOOLBARMANAGER_H_
//=============================================================================
//
//   File : kvi_customtoolbarmanager.h
//   Created on Sun 05 Dec 2004 18:20:18 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2004 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_pointerhashtable.h"

#ifdef COMPILE_ON_WINDOWS
	#include "kvi_customtoolbardescriptor.h"
#else
	class KviCustomToolBarDescriptor;
#endif

class KviCustomToolBar;

// THIS IS A COMPATIBILITY ENTRY ADDED AT 3.0.2 TIME THAT SHOULD BE DROPPED IN A COUPLE OF VERSION BUMPS!
#define SCRIPTTOOLBAR_COMPAT 1

class KVIRC_API KviCustomToolBarManager
{
protected:
	KviCustomToolBarManager();
	~KviCustomToolBarManager();
protected:
	static KviCustomToolBarManager * m_pInstance;
	KviPointerHashTable<TQString,KviCustomToolBarDescriptor> * m_pDescriptors;
public:
	static KviCustomToolBarManager * instance(){ return m_pInstance; };
	static void init();
	static void done();
	void clear();
	int descriptorCount(){ return m_pDescriptors->count(); };
	int visibleToolBarCount();
	TQString idForNewToolBar(const TQString &szTemplate);
	KviPointerHashTable<TQString,KviCustomToolBarDescriptor> * descriptors(){ return m_pDescriptors; };
	KviCustomToolBar * firstExistingToolBar();
	KviCustomToolBarDescriptor * create(const TQString &szId,const TQString &szLabelCode);
	KviCustomToolBarDescriptor * find(const TQString &szId){ return m_pDescriptors->find(szId); };
	KviCustomToolBarDescriptor * findDescriptorByInternalId(int id);
	void updateVisibleToolBars();
	void createToolBarsVisibleAtStartup();
	void storeVisibilityState();
	bool renameDescriptor(const TQString &szId,const TQString &szNewId,const TQString &szNewLabelCode);
	bool destroyDescriptor(const TQString &szId);
	void load(const TQString &szFileName);
	// THIS IS A COMPATIBILITY ENTRY ADDED AT 3.0.2 TIME THAT SHOULD BE DROPPED IN A COUPLE OF VERSION BUMPS!
#ifdef SCRIPTTOOLBAR_COMPAT
	void loadScripttoolbarsCompat(const TQString &szFileName);
#endif
	void save(const TQString &szFileName);
};


#endif //!_KVI_CUSTOMTOOLBARMANAGER_H_
