/*
    Rosegarden
    A sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <bownie@bownie.com>

    The moral right of the authors to claim authorship of this work
    has been asserted.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef TQCANVASSIMPLESPRITE_H
#define TQCANVASSIMPLESPRITE_H

#include <tqwmatrix.h>
#include <tqcanvas.h>

#include "gui/editors/notation/NotePixmapFactory.h"

namespace Rosegarden {

/**
 * A QCanvasSprite with 1 frame only
 */
class QCanvasSimpleSprite : public TQCanvasSprite
{
public:
    QCanvasSimpleSprite(TQPixmap*, TQCanvas*);
    QCanvasSimpleSprite(TQCanvasPixmap*, TQCanvas*);
    QCanvasSimpleSprite(const TQString &pixmapfile, TQCanvas*);

    // For lazy pixmap rendering, when we get around looking at it
    QCanvasSimpleSprite(TQCanvas*);

    virtual ~QCanvasSimpleSprite();

protected:
    static TQCanvasPixmapArray* makePixmapArray(TQPixmap *pixmap);

    static TQCanvasPixmapArray* makePixmapArray(TQCanvasPixmap *pixmap);

    static TQCanvasPixmapArray* makePixmapArray(const TQString &pixmapfile);

    //--------------- Data members ---------------------------------

    TQCanvasPixmapArray* m_pixmapArray;
};

class NotationElement;

/**
 * A QCanvasSprite referencing a NotationElement
 */
class TQCanvasNotationSprite : public QCanvasSimpleSprite
{
public:
    TQCanvasNotationSprite(Rosegarden::NotationElement&, TQPixmap*, TQCanvas*);
    TQCanvasNotationSprite(Rosegarden::NotationElement&, TQCanvasPixmap*, TQCanvas*);

    virtual ~TQCanvasNotationSprite();
    
    Rosegarden::NotationElement& getNotationElement() { return m_notationElement; }

protected:
    //--------------- Data members ---------------------------------

    Rosegarden::NotationElement& m_notationElement;
};

class TQCanvasNonElementSprite : public QCanvasSimpleSprite
{
public:
    TQCanvasNonElementSprite(TQPixmap *, TQCanvas *);
    TQCanvasNonElementSprite(TQCanvasPixmap *, TQCanvas *);
    virtual ~TQCanvasNonElementSprite();
};

/**
 * A QCanvasSprite used for a time signature
 */
class TQCanvasTimeSigSprite : public TQCanvasNonElementSprite
{
public:
    TQCanvasTimeSigSprite(double layoutX, TQPixmap *, TQCanvas *);
    TQCanvasTimeSigSprite(double layoutX, TQCanvasPixmap *, TQCanvas *);
    virtual ~TQCanvasTimeSigSprite();

    void setLayoutX(double layoutX) { m_layoutX = layoutX; }
    double getLayoutX() const { return m_layoutX; }

protected:
    double m_layoutX;
};

/**
 * A QCanvasSprite used for a staff name
 */
class QCanvasStaffNameSprite : public TQCanvasNonElementSprite
{
public:
    QCanvasStaffNameSprite(TQPixmap *, TQCanvas *);
    QCanvasStaffNameSprite(TQCanvasPixmap *, TQCanvas *);
    virtual ~QCanvasStaffNameSprite();
};

/**
 * A GC for TQCanvasPixmapArray which have to be deleted seperatly
 */
class PixmapArrayGC
{
public:
    static void registerForDeletion(TQCanvasPixmapArray*);
    static void deleteAll();
    
protected:
    //--------------- Data members ---------------------------------

    static std::vector<TQCanvasPixmapArray*> m_pixmapArrays;
};

}

#endif
