/*
    Rosegarden
    A MIDI and audio sequencer and musical notation editor.

    This program is Copyright 2000-2008
        Guillaume Laurent   <glaurent@telegraph-road.org>,
        Chris Cannam        <cannam@all-day-breakfast.com>,
        Richard Bown        <richard.bown@ferventsoftware.com>

    The moral rights of Guillaume Laurent, Chris Cannam, and Richard
    Bown to claim authorship of this work have been asserted.

    Other copyrights also apply to some parts of this work.  Please
    see the AUTHORS file and individual file headers for details.

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License as
    published by the Free Software Foundation; either version 2 of the
    License, or (at your option) any later version.  See the file
    COPYING included with this distribution for more information.
*/

#ifndef _RG_REMOVEMARKERCOMMAND_H_
#define _RG_REMOVEMARKERCOMMAND_H_

#include <string>
#include <kcommand.h>
#include <tqstring.h>
#include "base/Event.h"
#include <tdelocale.h>




namespace Rosegarden
{

class Marker;
class Composition;


class RemoveMarkerCommand : public KNamedCommand
{
public:
    RemoveMarkerCommand(Composition *comp,
                        int id,
                        timeT time,
                        const std::string &name,
                        const std::string &description);
    ~RemoveMarkerCommand();

    static TQString getGlobalName() { return i18n("&Remove Marker"); }

    virtual void execute();
    virtual void unexecute();

protected:

    Composition     *m_composition;
    Marker          *m_marker;
    int              m_id;
    timeT            m_time;
    std::string                  m_name;
    std::string                  m_descr;
    bool                         m_detached;

};


}

#endif
