/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef TOPLEVEL_H
#define TOPLEVEL_H

#include <tdeapplication.h>
#include <tqpopupmenu.h>
#include <tqtimer.h>
#include <tqlineedit.h>
#include <tqvaluevector.h>
#include <tqlistview.h>
#include <tqpushbutton.h>
#include <tqgroupbox.h>
#include <knuminput.h>
#include <ksystemtray.h>
#include <tqpixmap.h>
#include <kdirwatch.h>

#include <libtdeldap.h>

class TDEAction;
class KDialogBase;
class TQCheckBox;
class TimeEdit;

class TopLevel : public KSystemTray
{
	TQ_OBJECT

public:

	TopLevel();
	~TopLevel();

protected:
	void paintEvent(TQPaintEvent *);
	void mousePressEvent(TQMouseEvent *);
	void timerEvent(TQTimerEvent *);
	void resizeEvent(TQResizeEvent *);

private slots:
	void load();
	void save();
	void config();
	void help();
	void setToolTip(const TQString &text, bool force=false);

	void setupTimers();
	void requestTicketListUpdate();
	void updateTicketList();
	void updateMenu();
	void getNewTGT();
	void getNewServiceTicket();
	void getNewServiceTicketWithExistingCreds();
	void getNewTicket(bool requestServiceTicket=false);
	void destroyAllTickets();
	void showTicketList();
	void menuAction(int index);

private:
	TQPixmap activeTicketsPixmap;
	TQPixmap noTicketsPixmap;
	TQPixmap expiredTicketsPixmap;
	TQPixmap partiallyExpiredTicketsPixmap;
	TQPixmap timerOverlayPixmap;
	TQPixmap warningOverlayPixmap;
	TDEAction *confAct;
	TDEAction *getNewTGTAct;
	TDEAction *getNewSTAct;
	TDEAction *getNewStandardSTAct;
	TDEAction *destroyAllAct;
	TQPopupMenu *menu;
	TQString lastTip;
	KerberosTicketInfoList m_ticketList;
	TQString m_ticketFile;
	KDirWatch *ticketWatch;
	TQTimer *m_refreshTimer;
	TQTimer *m_requestUpdateTimer;

	bool autostart;
	bool notifyExpiry;
	int notifyExpiryMinutes;

	friend class KTMConfigureDialog;
};

#endif
