/***************************************************************************
    copyright            : (C) 2003-2005 by Robby Stephenson
    email                : robby@periapsis.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of version 2 of the GNU General Public License as  *
 *   published by the Free Software Foundation;                            *
 *                                                                         *
 ***************************************************************************/

#ifndef RATINGWIDGET_H
#define RATINGWIDGET_H

#include <ntqhbox.h>
#include <ntqptrlist.h>
#include <ntqlabel.h>
#include <ntqpixmap.h>
#include <ntqstringlist.h>

/**
 * @author Robby Stephenson
 */
class RatingWidget : public TQHBox {
TQ_OBJECT

typedef TQPtrList<TQLabel> LabelList;

public:
  RatingWidget(int stars, TQWidget* parent, const char* name = 0);

  void clear();
  TQString text() const;
  void setText(const TQString& text);

  static const TQPixmap& pixmap(const TQString& value);

public slots:
  void update();

signals:
  void modified();

protected:
  virtual void mousePressEvent(TQMouseEvent* e);

private:
  void init();

  LabelList m_widgets;

  int m_currIndex;
  int m_total;
  int m_min;
  int m_max;

  TQPixmap m_pixOn;
  TQPixmap m_pixOff;
  TQPixmap m_pixHalf;
};
#endif
