/***************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef KRELISTVIEW_H
#define KRELISTVIEW_H

#include <ntqlabel.h>
#include <ntqvbox.h>
#include <tdelistview.h>
#include <klineedit.h>

class DBListViewBase;

/**
@author Unai Garro
*/

class KreListView: public TQVBox
{
	TQ_OBJECT
public:

	KreListView( TQWidget *parent, const TQString &title = TQString::null, bool filter = false, int filterCol = 0, TQWidget *embeddedWidget = 0 );
	~KreListView();
	TDEListView *listView()
	{
		return list;
	}

	void setListView( TDEListView *list_view )
	{
		delete list;
		list = list_view;
	}
	void setListView( DBListViewBase *list_view );

	void setCustomFilter( TQObject *receiver, const char *slot );
	TQString filterText() const { return filterEdit->text(); }

public slots:
	void refilter();

signals:
	void textChanged( const TQString & );

private:
	TQHBox *filterBox;
	TQLabel *listLabel;
	int filteredColumn;
	TQLabel *filterLabel;
	KLineEdit *filterEdit;
	TDEListView *list;

private slots:
	void filter( const TQString& s );
};

#endif
