/***************************************************************************
*   Copyright (C) 2004-2005 by                                            *
*   Jason Kivlighn (jkivlighn@gmail.com)                                  *
*                                                                         *
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#include "krelistview.h"

#include <tdeglobalsettings.h>
#include <tdelocale.h>
#include <kdebug.h>

#include "widgets/dblistviewbase.h"

KreListView::KreListView( TQWidget *parent, const TQString &title, bool filter, int filterCol, TQWidget *embeddedWidget ) : TQVBox( parent )
{

	filteredColumn = filterCol;
	TQWidget *header = this;
	if ( filter || embeddedWidget ) {
		header = new TQHBox( this );
		( ( TQHBox* ) header ) ->setSpacing( 15 );
	}

	if ( !title.isNull() ) {
		listLabel = new TQLabel( header );
		listLabel->setFrameShape( TQFrame::GroupBoxPanel );
		listLabel->setFrameShadow( TQFrame::Sunken );
		listLabel->setPaletteForegroundColor( TDEGlobalSettings::highlightedTextColor() );
		listLabel->setPaletteBackgroundColor( TDEGlobalSettings::highlightColor().light( 120 ) ); // 120, to match the kremenu settings
		listLabel->setText( title );

	}

	if ( filter ) {
		filterBox = new TQHBox( header );
		filterBox->setFrameShape( TQFrame::Box );
		filterBox->setMargin( 2 );
		filterLabel = new TQLabel( filterBox );
		filterLabel->setText( i18n( "Search:" ) );
		filterEdit = new KLineEdit( filterBox );
	}


	list = new TDEListView( this );
	list->setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding );
	setSizePolicy( TQSizePolicy::MinimumExpanding, TQSizePolicy::MinimumExpanding );
	setSpacing( 10 );


	// If the user provides a widget, embed it into the header
	if ( embeddedWidget )
		embeddedWidget->reparent( header, TQPoint( 0, 0 ) );
	//Connect Signals & Slots
	if ( filter ) {
		connect( filterEdit, SIGNAL( textChanged( const TQString& ) ), SIGNAL( textChanged(const TQString&) ) );
		connect( this, SIGNAL( textChanged( const TQString& ) ), SLOT( filter( const TQString& ) ) );
	}
}

KreListView::~KreListView()
{}

void KreListView::filter( const TQString& s )
{
	for ( TQListViewItem * it = list->firstChild();it;it = it->nextSibling() ) {
		if ( it->rtti() == NEXTLISTITEM_RTTI || it->rtti() == PREVLISTITEM_RTTI )
			continue;

		if ( s.isEmpty() )  // Don't filter if the filter text is empty
		{
			it->setVisible( true );
		}
		else
		{

			if ( it->text( filteredColumn ).contains( s, false ) )
				it->setVisible( true );
			else
				it->setVisible( false );

		}


	}
}

void KreListView::refilter()
{
	if ( !filterEdit->text().isEmpty() ) {
		emit textChanged( filterEdit->text() );
	}
}

void KreListView::setCustomFilter( TQObject *receiver, const char *slot )
{
	connect( this, SIGNAL( textChanged( const TQString& ) ), receiver, slot );
}

void KreListView::setListView( DBListViewBase *list_view )
{
	delete list;

	connect( list_view, SIGNAL( nextGroupLoaded() ), SLOT( refilter() ) );
	connect( list_view, SIGNAL( prevGroupLoaded() ), SLOT( refilter() ) );
	list = list_view;
}

#include "krelistview.moc"
