/**************************************************************************
*   Copyright (C) 2003 by                                                 *
*   Unai Garro (ugarro@users.sourceforge.net)                             *
*   Cyril Bosselut (bosselut@b1project.com)                               *
*   Jason Kivlighn(jkivlighn@gmail.com)                                   *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
***************************************************************************/

#ifndef SELECTRECIPEDIALOG_H
#define SELECTRECIPEDIALOG_H


#include <ntqwidget.h>
#include <ntqpushbutton.h>
#include <ntqlabel.h>
#include <ntqlayout.h>
#include <ntqcursor.h>
#include <ntqintdict.h>

#include <kcombobox.h>
#include <klineedit.h>
#include <tdelistview.h>
#include <kdialog.h>
#include <tdefiledialog.h>
#include <tdepopupmenu.h>

#include "recipeactionshandler.h"
#include "widgets/dblistviewbase.h"

class TQHBox;
class TQGroupBox;

class RecipeDB;
class ElementList;
class Recipe;
class AdvancedSearchDialog;
class CategoryTree;
class RecipeFilter;
class RecipeListView;
class CategoryComboBox;

/**
@author Unai Garro
*/
class SelectRecipeDialog : public TQWidget
{
	TQ_OBJECT
public:
	SelectRecipeDialog( TQWidget *parent, RecipeDB *db );
	~SelectRecipeDialog();


	//Public Methods
	void getCurrentRecipe( Recipe *recipe );

	RecipeActionsHandler * getActionsHandler() const;

private:

	// Widgets
	TQGridLayout *layout;
	TQTabWidget *tabWidget;
	TQGroupBox *basicSearchTab;
	TQHBox *searchBar;
	RecipeListView* recipeListView;
	TQHBox *buttonBar;
	TQPushButton *openButton;
	TQPushButton *removeButton;
	TQPushButton *editButton;
	TQLabel *searchLabel;
	KLineEdit *searchBox;
	CategoryComboBox *categoryBox;
	AdvancedSearchDialog *advancedSearch;
	// Internal Data
	RecipeDB *database;
	RecipeActionsHandler *actionHandler;
	RecipeFilter *recipeFilter;

signals:
	void recipeSelected( int id, int action );
	void recipesSelected( const TQValueList<int> &ids, int action );
	void recipeSelected( bool );

private slots:
	void filterComboCategory( int row );
	void refilter();
	void ensurePopulated();

public slots:
	void haveSelectedItems();
	void reload( ReloadFlags flag = Load );
	void clearSearch();
};

#endif
