/*
 * Copyright Johannes Sixt
 * This file is licensed under the GNU General Public License Version 2.
 * See the file COPYING in the toplevel directory of the source directory.
 */

#include "pgmsettings.h"
#include <tdelocale.h>			/* i18n */
#include <tdeapplication.h>
#include <tqfileinfo.h>
#include <tqlayout.h>
#include <tqlineedit.h>
#include <tqlabel.h>
#include <tqradiobutton.h>
#include <tqbuttongroup.h>
#include "config.h"
#include "mydebug.h"


ChooseDriver::ChooseDriver(TQWidget* parent) :
	TQWidget(parent, "driver")
{
    TQVBoxLayout* layout = new TQVBoxLayout(this, 10);

    TQLabel* label = new TQLabel(this);
    label->setText(i18n("How to invoke &GDB - leave empty to use\n"
			"the default from the global options:"));
    label->setMinimumSize(label->sizeHint());
    layout->addWidget(label);

    m_debuggerCmd = new TQLineEdit(this);
    m_debuggerCmd->setMinimumSize(m_debuggerCmd->sizeHint());
    layout->addWidget(m_debuggerCmd);
    label->setBuddy(m_debuggerCmd);

    layout->addStretch(10);
}

void ChooseDriver::setDebuggerCmd(const TQString& cmd)
{
    m_debuggerCmd->setText(cmd);
}

TQString ChooseDriver::debuggerCmd() const
{
    return m_debuggerCmd->text();
}


OutputSettings::OutputSettings(TQWidget* parent) :
	TQWidget(parent, "output")
{
    // the group is invisible
    m_group = new TQButtonGroup(this);
    m_group->hide();

    TQVBoxLayout* layout = new TQVBoxLayout(this, 10);

    TQRadioButton* btn;

    btn = new TQRadioButton(i18n("&No input and output"), this);
    m_group->insert(btn, 0);
    btn->setMinimumSize(btn->sizeHint());
    layout->addWidget(btn);

    btn = new TQRadioButton(i18n("&Only output, simple terminal emulation"), this);
    m_group->insert(btn, 1);
    btn->setMinimumSize(btn->sizeHint());
    layout->addWidget(btn);

    btn = new TQRadioButton(i18n("&Full terminal emulation"), this);
    m_group->insert(btn, 7);
    btn->setMinimumSize(btn->sizeHint());
    layout->addWidget(btn);

    layout->addStretch(10);

    // there is no simpler way to get to the active button than
    // to connect to a signal
    connect(m_group, SIGNAL(clicked(int)), SLOT(slotLevelChanged(int)));
}

void OutputSettings::setTTYLevel(int l)
{
    m_group->setButton(l);
    m_ttyLevel = l;
}

void OutputSettings::slotLevelChanged(int id)
{
    m_ttyLevel = id;
    TRACE("new ttyLevel: " + TQString().setNum(id));
}



ProgramSettings::ProgramSettings(TQWidget* parent, TQString exeName, bool modal) :
	TQTabDialog(parent, "program_settings", modal),
	m_chooseDriver(this),
	m_output(this)
{
    // construct title
    TQFileInfo fi(exeName);
    TQString cap = kapp->caption();
    TQString title = i18n("%1: Settings for %2");
    setCaption(title.arg(cap, fi.fileName()));

    setCancelButton(i18n("Cancel"));
    setOKButton(i18n("OK"));

    addTab(&m_chooseDriver, i18n("&Debugger"));
    addTab(&m_output, i18n("&Output"));
}

#include "pgmsettings.moc"
