###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### Trace outputs

if( WITH_TRACE_OUTPUT )
  set( WANT_TRACE_OUTPUT 1 )
endif( WITH_TRACE_OUTPUT )


##### gdb-transcript

if( WITH_GDB_TRANSCRIPT )
  set( GDB_TRANSCRIPT "./gdb-transcript" CACHE STRING "user specified file")
endif( WITH_GDB_TRANSCRIPT )


##### check for headers

check_include_file( "fcntl.h"     HAVE_FCNTL_H     )
check_include_file( "unistd.h"    HAVE_UNISTD_H    )
check_include_file( "sys/ioctl.h" HAVE_SYS_IOCTL_H )
check_include_file( "sys/stat.h"  HAVE_SYS_STAT_H  )
check_include_file( "pty.h"       HAVE_PTY_H       )
check_include_file( "libutil.h"   HAVE_LIBUTIL_H   )
check_include_file( "util.h"      HAVE_UTIL_H      )


##### search for 'ps' command

find_program( PS_COMMAND "ps" DOC "Path for the ps command" )


##### check for mkfifo function

check_function_exists( mkfifo HAVE_MKFIFO )
