/* This file is based on tdefiledetailview.h v1.30 from the KDE libs. Original
   copyright follows.
*/
/* This file is part of the KDE libraries
	Copyright (C) 1997 Stephan Kulow <coolo@kde.org>

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public License
	along with this library; see the file COPYING.LIB.	If not, write to
	the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
	Boston, MA 02110-1301, USA.
*/

#ifndef FILEDETAILVIEW_H
#define FILEDETAILVIEW_H

class KFileItem;
class TQWidget;
class TQKeyEvent;

// TQt includes
#include <tqdir.h>

// KDE includes
#include <tdelistview.h>
#include <kmimetyperesolver.h>

// Our includes
#include "fileviewbase.h"
namespace Gwenview {

class FileDetailViewItem;

class FileDetailView : public TDEListView, public FileViewBase
{
	TQ_OBJECT
  

	friend class FileDetailViewItem;

public:
	FileDetailView(TQWidget* parent, const char* name);
	virtual ~FileDetailView();

	virtual TQWidget* widget() { return this; }
	virtual void clearView();

	virtual void updateView( bool );
	virtual void updateView(const KFileItem*);
	virtual void removeItem( const KFileItem* );
	virtual void listingCompleted();

	virtual void setSelected(const KFileItem* , bool);
	virtual bool isSelected(const KFileItem* i) const;
	virtual void clearSelection();
	virtual void selectAll();
	virtual void invertSelection();

	virtual void setCurrentItem( const KFileItem* );
	virtual KFileItem* currentFileItem() const;
	virtual KFileItem* firstFileItem() const;
	virtual KFileItem* nextItem( const KFileItem* ) const;
	virtual KFileItem* prevItem( const KFileItem* ) const;

	virtual void insertItem( KFileItem* i );

	// implemented to get noticed about sorting changes (for sortingIndicator)
	virtual void setSorting( TQDir::SortSpec );

	void ensureItemVisible( const KFileItem*  );

	// for KMimeTypeResolver
	void mimeTypeDeterminationFinished();
	void determineIcon( FileDetailViewItem* item );
	TQScrollView* scrollWidget() { return this; }
	
	void setShownFileItem(KFileItem* fileItem);

signals:
	void dropped(TQDropEvent* event, KFileItem* item);
	void sortingChanged(TQDir::SortSpec);
	
protected:
	virtual bool acceptDrag(TQDropEvent*) const;
	virtual void contentsDropEvent(TQDropEvent*);
	virtual void keyPressEvent(TQKeyEvent*);

	int mSortingCol;

protected slots:
	void slotSelectionChanged();

private slots:
	void slotSortingChanged( int );
	void selected( TQListViewItem* item );
	void slotActivate( TQListViewItem* item );
	void highlighted( TQListViewItem* item );
	void slotActivateMenu ( TQListViewItem* item, const TQPoint& pos );

private:
	bool mBlockSortingSignal;
	KMimeTypeResolver<FileDetailViewItem,FileDetailView>* mResolver;

	virtual void insertItem(TQListViewItem* i) { TDEListView::insertItem(i); }
	virtual void setSorting(int i, bool b) { TDEListView::setSorting(i, b); }
	virtual void setSelected(TQListViewItem* i, bool b) { TDEListView::setSelected(i, b); }

	FileDetailViewItem* viewItem( const KFileItem* item ) const {
		if (item) return (FileDetailViewItem*)item->extraData(this);
		return 0L;
	}

	void setSortingKey(FileDetailViewItem* item, const KFileItem* i);
	
	void startDrag();

	TQPixmap mShownItemSelectedPixmap;
	TQPixmap mShownItemUnselectedPixmap;
};


} // namespace
#endif

