/***************************************************************************
                          sq_kipiinterface.cpp  -  description
                             -------------------
    begin                :  Feb 5 2007
    copyright            : (C) 2007 by Baryshev Dmitry
    email                : ksquirrel.iv@gmail.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "sq_kipiinterface.h"

#ifdef SQ_HAVE_KIPI

#include <tdefileitem.h>
#include <tdelocale.h>
#include <kurl.h>
#include <tdefileview.h>
#include <tdefileiconview.h>
#include <kdirlister.h>

#include <libkipi/imagecollectionshared.h>
#include <libkipi/imageinfoshared.h>

#include "sq_widgetstack.h"
#include "sq_diroperator.h"
#include "sq_imagebasket.h"
#include "sq_hloptions.h"

class SQ_KIPIImageCollection : public KIPI::ImageCollectionShared
{
    public:
	SQ_KIPIImageCollection(const TQString& name, const KURL::List& images)
	    : KIPI::ImageCollectionShared(), mName(name), mImages(images)
        {}

        TQString name()
        {
            return mName;
        }

        TQString comment()
        {
            return TQString();
        }

	KURL::List images()
        {
            return mImages;
        }

	// FIXME: Return current URL instead
	KURL uploadPath()
        {
            KURL url;
            url.setPath("/");
            return url;
	}

        TQString uploadRootName()
        {
            return i18n("Root directory");
        }

    private:
        TQString mName;
        KURL::List mImages;
};

/***************************************************************/

class SQ_KIPIImageInfo : public KIPI::ImageInfoShared
{
    public:
        SQ_KIPIImageInfo(KIPI::Interface *interface, const KURL &url)
            : KIPI::ImageInfoShared(interface, url)
        {}

        TQString title()
        {
            return _url.fileName();
	}
	
        TQString description()
        {
            return TQString();
        }

        void setDescription(const TQString&)
        {}

        TQStringVariantMap attributes()
        {
            return TQStringVariantMap();
        }

        void clearAttributes()
        {}

        void addAttributes(const TQStringVariantMap&)
        {}
};


/***************************************************************/

SQ_KIPIInterface::SQ_KIPIInterface(TQWidget *parent)
 : KIPI::Interface(TQT_TQOBJECT(parent), "KSquirrel KIPI Interface")
{
    connect(SQ_WidgetStack::instance()->diroperator(), TQT_SIGNAL(fileHighlighted(const KFileItem *)),
        this, TQT_SLOT(slotSelectionChanged()));

    connect(SQ_WidgetStack::instance()->diroperator()->dirLister(), TQT_SIGNAL(completed(const KURL&)),
        this, TQT_SLOT(slotDirectoryChanged()));
}

SQ_KIPIInterface::~SQ_KIPIInterface()
{}

KIPI::ImageCollection SQ_KIPIInterface::currentAlbum()
{
    KURL::List list;

    const KFileItemList *l = SQ_WidgetStack::instance()->diroperator()->view()->items();

    if(l)
    {
        KFileItemListIterator it(*l);

        for( ; it.current(); ++it)
            list.append(it.current()->url());
    }

    return KIPI::ImageCollection(new SQ_KIPIImageCollection(i18n("Folder content"), list)); 
}

KIPI::ImageCollection SQ_KIPIInterface::currentSelection()
{
    KURL::List list;

    const KFileItemList *l = SQ_WidgetStack::instance()->diroperator()->selectedItems();

    if(l)
    {
        KFileItemListIterator it(*l);

        for( ; it.current(); ++it)
            list.append(it.current()->url());
    }

    return KIPI::ImageCollection(new SQ_KIPIImageCollection(i18n("Selected images"), list)); 
}

KIPI::ImageCollection SQ_KIPIInterface::currentBasket()
{
    KURL::List list;

    KFileItemList l = SQ_ImageBasket::instance()->realItems();

    KFileItemListIterator it(l);

    for( ; it.current(); ++it)
        list.append(it.current()->url());

    return KIPI::ImageCollection(new SQ_KIPIImageCollection(i18n("Image basket"), list)); 
}

TQValueList<KIPI::ImageCollection> SQ_KIPIInterface::allAlbums()
{
    TQValueList<KIPI::ImageCollection> list;

    list << currentAlbum() << currentSelection();

    if(SQ_HLOptions::instance()->have_imagebasket)
        list << currentBasket();

    return list;
}

KIPI::ImageInfo SQ_KIPIInterface::info(const KURL& url)
{
    return KIPI::ImageInfo(new SQ_KIPIImageInfo(this, url));
}

int SQ_KIPIInterface::features() const
{
    return KIPI::AcceptNewImages; 
}

void SQ_KIPIInterface::slotSelectionChanged()
{
    emit selectionChanged(SQ_WidgetStack::instance()->diroperator()->selectedItems()->count() > 0);
}

void SQ_KIPIInterface::slotDirectoryChanged()
{
    emit currentAlbumChanged(SQ_WidgetStack::instance()->diroperator()->numFiles() > 0);
}

#include "sq_kipiinterface.moc"

#endif
