/***************************************************************************
                       lirc-configuration.h  -  description
                             -------------------
    begin                : Sat May 21 2005
    copyright            : (C) 2005 by Martin Witte
    email                : witte@kawo1.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRADIO_LIRC_CONFIGURATION_H
#define KRADIO_LIRC_CONFIGURATION_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "lirc-configuration-ui.h"
#include "lircsupport.h"
#include "listviewitem_lirc.h"

class LIRCConfiguration : public LIRCConfigurationUI
{
TQ_OBJECT
  
public :
    LIRCConfiguration (TQWidget *parent, LircSupport *);
    ~LIRCConfiguration ();

protected slots:

    void slotOK();
    void slotCancel();
    void slotSetDirty();

    void slotUpdateConfig();
    void slotRawLIRCSignal(const TQString &val, int repeat_counter, bool &consumed);

    void slotRenamingStarted(ListViewItemLirc *, int);
    void slotRenamingStopped(ListViewItemLirc *, int);

protected:
    void addKey(const TQString &descr, const TQString &key, const TQString &alt_key);

    LircSupport *m_LIRC;

    TQMap<int, LIRC_Actions>     m_order;
    TQMap<LIRC_Actions, TQString> m_descriptions;
    
    bool  m_dirty;
    bool  m_ignore_gui_updates;
};

#endif
