/*
 * tdeumaskinput.cpp
 *
 *  Copyright (c) 2013 Timothy Pearson <kb9vqf@pearsoncomputing.net>
 *
 *  Requires the Qt widget libraries, available at no cost at
 *  http://www.troll.no/
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this library; see the file COPYING.LIB.  If not, write to
 *  the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 *  Boston, MA 02110-1301, USA.
 */

#include "tdeumaskinput.h"

TDEUmaskInput::TDEUmaskInput(TQWidget *parent, const char *name)
    : KIntSpinBox(parent, name)
{
	//
}

TDEUmaskInput::TDEUmaskInput(int lower, int upper, int step, int value, int base,
                         TQWidget* parent, const char* name)
    : KIntSpinBox(lower, upper, step, value, base, parent, name)
{
	//
}

TDEUmaskInput::~TDEUmaskInput()
{
	//
}

void TDEUmaskInput::setBase(int base)
{
	KIntSpinBox::setBase(base);
}

int TDEUmaskInput::base() const
{
	return KIntSpinBox::base();
}

TQString TDEUmaskInput::mapValueToText (int v) {
	TQString baseText = KIntSpinBox::mapValueToText(v);
	while (baseText.length() < 4) {
		baseText.prepend("0");
	}
	return baseText;
}

#include "tdeumaskinput.moc"
