/***************************************************************************
 *   Copyright (C) 2012 by Timothy Pearson                                 *
 *   kb9vqf@pearsoncomputing.net                                           *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <tdelocale.h>
#include <klineedit.h>
#include <ktextedit.h>
#include <knuminput.h>
#include <tdeactionselector.h>
#include <tqlistbox.h>
#include <kpushbutton.h>
#include <tqpixmap.h>
#include <tqiconset.h>
#include <tqlabel.h>

#include "realmpropertiesdialog.h"

RealmPropertiesDialog::RealmPropertiesDialog(LDAPRealmConfigList *realmList, TQString realmName, TQWidget* parent, const char* name)
	: KDialogBase(parent, name, true, i18n("Realm Properties"), Ok|Cancel, Ok, true), m_realmList(realmList), m_realmName(realmName)
{
	m_base = new BondRealmPage(this);

	m_base->txtRealmName->setEnabled(false);
	m_base->txtKDC->setEnabled(false);
	m_base->txtKDCPort->setEnabled(false);
	m_base->txtAdminServer->setEnabled(false);
	m_base->txtAdminServerPort->setEnabled(false);

	m_base->px_introSidebar->hide();

	LDAPRealmConfig realm = (*m_realmList)[m_realmName];

	// Load values into dialog
	m_base->txtRealmName->setText(realm.name);
	m_base->txtUIDOffset->setValue(realm.uid_offset);
	m_base->txtGIDOffset->setValue(realm.gid_offset);
	m_base->txtDomains->setText(realm.domain_mappings.join("\n"));
	m_base->txtKDC->setText(realm.kdc);
	m_base->txtKDCPort->setValue(realm.kdc_port);
	m_base->txtAdminServer->setText(realm.admin_server);
	m_base->txtAdminServerPort->setValue(realm.admin_server_port);
	m_base->checkRequireEKU->setChecked(realm.pkinit_require_eku);
	m_base->checkRequireKrbtgtOtherName->setChecked(realm.pkinit_require_krbtgt_otherName);
	m_base->checkWin2k->setChecked(realm.win2k_pkinit);
	m_base->checkWin2kPkinitRequireBinding->setChecked(realm.win2k_pkinit_require_binding);

	setMainWidget(m_base);
}

void RealmPropertiesDialog::slotOk() {
	// Load values into realmcfg
	LDAPRealmConfig realm = (*m_realmList)[m_realmName];

	realm.name = m_base->txtRealmName->text();
	realm.uid_offset = m_base->txtUIDOffset->value();
	realm.gid_offset = m_base->txtGIDOffset->value();
	realm.domain_mappings = TQStringList::split("\n", m_base->txtDomains->text(), FALSE);
	realm.kdc = m_base->txtKDC->text();
	realm.kdc_port = m_base->txtKDCPort->value();
	realm.admin_server = m_base->txtAdminServer->text();
	realm.admin_server_port = m_base->txtAdminServerPort->value();
	realm.pkinit_require_eku = m_base->checkRequireEKU->isChecked();
	realm.pkinit_require_krbtgt_otherName = m_base->checkRequireKrbtgtOtherName->isChecked();
	realm.win2k_pkinit = m_base->checkWin2k->isChecked();
	realm.win2k_pkinit_require_binding = m_base->checkWin2kPkinitRequireBinding->isChecked();

	// Remove m_realmName and re-add it
	m_realmList->remove(m_realmName);
	m_realmList->insert(m_realmName, realm);

	accept();
}

#include "realmpropertiesdialog.moc"
