/***************************************************************************
 *   Copyright (C) 2005-2006 Nicolas Hadacek <hadacek@kde.org>             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#ifndef XML_TO_DATA_H
#define XML_TO_DATA_H

#include "common/global/global.h"
#  include <tqdom.h>
#include <tqstringlist.h>

class XmlToData
{
public:
  XmlToData() {}
  virtual ~XmlToData() {}
  void process();

protected:
  virtual void parse() = 0;
  virtual void output() = 0;
  virtual TQString currentDevice() const = 0;
  virtual void warning(const TQString &message) const;
  virtual void tqFatal(const TQString &message) const;
  TQDomElement findUniqueElement(TQDomElement parent, const TQString &nodeName,
                                const TQString &attribute, const TQString &value) const;
  void checkTagNames(TQDomElement element, const TQString &tag, const TQStringList &names) const;
  TQDomDocument parseFile(const TQString &filename) const;
};

#define XML_MAIN(_type) \
  int main(int, char **) \
  { \
    _type dx; \
    dx.process(); \
    return 0; \
  }

#endif
