/***************************************************************************
 *   Copyright (C) 2006 Nicolas Hadacek <hadacek@kde.org>                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/
#include "picc_compile.h"

#include "picc_config.h"

//-----------------------------------------------------------------------------
TQStringList PICC::Process::genericArguments(const Compile::Config &) const
{
  TQStringList args;
  args += "--ERRFORMAT";
  args += "--WARNFORMAT";
  args += "--MSGFORMAT";
  args += "--CHIP=%DEVICE";
  args += "--IDE=mplab";
  args += "-Q"; // suppress copyright message
  return args;
}

void PICC::Process::logStderrLine(const TQString &line)
{
  // #### TODO
  doLog(Log::LineType::Normal, line, TQString(), 0);
}

//-----------------------------------------------------------------------------
TQStringList PICC::CompileStandaloneFile::genericArguments(const Compile::Config &config) const
{
  TQStringList args = Process::genericArguments(config);
  args += "-M%MAP";
  args += "-G%SYM";
  args += "--ASMLIST";
  args += config.includeDirs(Tool::Category::Compiler, "-I");
  args += config.customOptions(Tool::Category::Compiler);
  args += "%I";
  return args;
}

TQString PICC::CompileStandaloneFile::outputFiles() const
{
  return "PURL::Lst PURL::Map obj PURL::Hex PURL::Coff sym sdb hxl rlf";
}

//-----------------------------------------------------------------------------
TQStringList PICC::CompileProjectFile::genericArguments(const Compile::Config &config) const
{
  TQStringList args = Process::genericArguments(config);
  args += "-S";
  args += config.includeDirs(Tool::Category::Compiler, "-I");
  args += config.customOptions(Tool::Category::Compiler);
  args += "%I";
  return args;
}

TQString PICC::CompileProjectFile::outputFiles() const
{
  return "PURL::AsmPICC";
}

//-----------------------------------------------------------------------------
TQStringList PICC::AssembleStandaloneFile::genericArguments(const Compile::Config &config) const
{
  TQStringList args = Process::genericArguments(config);
  args += "-M%MAP";
  args += "-G%SYM";
  args += "--ASMLIST";
  args += config.includeDirs(Tool::Category::Assembler, "-I");
  args += config.customOptions(Tool::Category::Assembler);
  args += "%I";
  return args;
}

TQString PICC::AssembleStandaloneFile::outputFiles() const
{
  return "PURL::Lst PURL::Map obj PURL::Hex sym sdb hxl rlf";
}

//-----------------------------------------------------------------------------
TQStringList PICC::AssembleProjectFile::genericArguments(const Compile::Config &config) const
{
  TQStringList args = Process::genericArguments(config);
  args += "-C";
  args += "--ASMLIST";
  args += config.includeDirs(Tool::Category::Assembler, "-I");
  args += config.customOptions(Tool::Category::Assembler);
  args += "%I";
  return args;
}

TQString PICC::AssembleProjectFile::outputFiles() const
{
  return "obj PURL::Lst rlf";
}

//-----------------------------------------------------------------------------
TQStringList PICC::LinkProject::genericArguments(const Compile::Config &config) const
{
  TQStringList args = Process::genericArguments(config);
  args += "-O%O";
  args += "-M%MAP";
  args += "-G%SYM";
  if ( _data.linkType==Compile::Icd2Linking ) args += "--DEBUGGER=icd2";
  args += config.customOptions(Tool::Category::Linker);
  args += "%OBJS";
  args += "%LIBS";
  args += config.customLibraries(Tool::Category::Linker);
  return args;
}

TQString PICC::LinkProject::outputFiles() const
{
  return "PURL::Map PURL::Hex PURL::Coff sym sdb hxl";
}

//-----------------------------------------------------------------------------
TQStringList PICC::LibraryProject::genericArguments(const Compile::Config &config) const
{
  TQStringList args;
  args += config.customOptions(Tool::Category::Librarian);
  args += "r";
  args += "%O";
  args += "%OBJS";
  args += "%LIBS";
  return args;
}

TQString PICC::LibraryProject::outputFiles() const
{
  return "PURL::Library";
}
