###########################################
#                                         #
#  Improvements and feedback are welcome  #
#                                         #
#  This file is released under GPL >= 3   #
#                                         #
###########################################

# required stuff
find_package( TQt )
find_package( TDE )

tde_setup_architecture_flags( )

include(TestBigEndian)
test_big_endian(WORDS_BIGENDIAN)

tde_setup_largefiles( )


##### check for gcc visibility support

if( WITH_GCC_VISIBILITY )
  tde_setup_gcc_visibility( )
endif( WITH_GCC_VISIBILITY )


##### check for headers

check_include_file( "slapi-plugin.h" HAVE_SLAPI_PLUGIN_H )
check_include_file( "sys/bitypes.h" HAVE_SYS_BITYPES_H )
check_include_file( "sys/types.h" HAVE_SYS_TYPES_H )
check_include_file( "stdint.h" HAVE_STDINT_H )


##### check for ldap

find_library( HAVE_LIBLDAP ldap )
if( HAVE_LIBLDAP )
   set( LDAP_LIBRARIES "ldap" )
  else()
   tde_message_fatal( "ldap is required, but was not found on your system" )
endif( HAVE_LIBLDAP )


##### check for openldap-server

if( NOT DEFINED SLAPI_LIBRARIES )
  message( STATUS "Looking for slapi library" )
  find_library( HAVE_SLAPI slapi )
  if( HAVE_SLAPI )
     set( SLAPI_LIBRARIES slapi )
    else()
     get_filename_component( LDAP_LIBDIR ${HAVE_LIBLDAP} PATH CACHE )
     file( GLOB LIBSLAPI_FILES
           ${LDAP_LIBDIR}/${CMAKE_SHARED_LIBRARY_PREFIX}slapi-[0-9]*${CMAKE_SHARED_LIBRARY_SUFFIX}
           ${LDAP_LIBDIR}/${CMAKE_SHARED_LIBRARY_PREFIX}slapi-[0-9]*${CMAKE_SHARED_LIBRARY_SUFFIX}.[0-9]*
           /usr/lib/${CMAKE_SHARED_LIBRARY_PREFIX}slapi-[0-9]*${CMAKE_SHARED_LIBRARY_SUFFIX}
           /usr/lib/${CMAKE_SHARED_LIBRARY_PREFIX}slapi-[0-9]*${CMAKE_SHARED_LIBRARY_SUFFIX}.[0-9]*
     )
     if( LIBSLAPI_FILES )
       list( GET LIBSLAPI_FILES 0 SLAPI_LIBRARIES )
      else( )
       tde_message_fatal( "The slapi library ( openldap-server ) is required, but was not found on your system" )
     endif( )
  endif( HAVE_SLAPI )
  message( STATUS "Looking for slapi library - found ${SLAPI_LIBRARIES}" )
endif( )


##### check for tdeldap

find_library( HAVE_LIBTDELDAP tdeldap )
if( HAVE_LIBTDELDAP )
   set( TDELDAP_LIBRARIES "tdeldap" )
  else()
   tde_message_fatal( "libtdeldap is required, but was not found on your system" )
endif( )


##### check for krb5

pkg_search_module( KRB5 heimdal-krb5 krb5 )
if( NOT KRB5_FOUND)
  if( NOT DEFINED KRB5_CONFIG_EXECUTABLE )
    find_program( KRB5_CONFIG_EXECUTABLE NAMES krb5-config.heimdal krb5-config )
    if( NOT KRB5_CONFIG_EXECUTABLE )
      tde_message_fatal( "krb5 library is required but not found on your system" )
    endif( )
  endif( )

  execute_process(
    COMMAND ${KRB5_CONFIG_EXECUTABLE} --libs
    OUTPUT_VARIABLE KRB5_LIBRARIES
    ERROR_VARIABLE KRB5_LIBRARIES
    OUTPUT_STRIP_TRAILING_WHITESPACE
    ERROR_STRIP_TRAILING_WHITESPACE
  )
  
  execute_process(
    COMMAND ${KRB5_CONFIG_EXECUTABLE} --cflags
    OUTPUT_VARIABLE KRB5_INCLUDE_DIRS
    ERROR_VARIABLE KRB5_INCLUDE_DIRS
    OUTPUT_STRIP_TRAILING_WHITESPACE
    ERROR_STRIP_TRAILING_WHITESPACE
  )
  
  if( NOT "${KRB5_LIBRARIES}" STREQUAL "" )
    set( KRB5_FOUND 1 )
  endif( )
endif( )
