/***************************************************************************
                          kooldock.h  -  description
                             -------------------
    begin                : Tue Jun 10 22:18:34 BST 2003
    copyright            : (C) 2003 by KoolDock team
    email                : 
 ***************************************************************************/

/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef KOOLDOCK_H
#define KOOLDOCK_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapp.h>
#include <tdepopupmenu.h>
#include <twinmodule.h>
#include <tdeaboutdialog.h>
#include <krootpixmap.h>
#include <kpixmap.h>
#include <kurifilter.h>

#include <tqwidget.h>
#include <tqptrlist.h>
#include <tqtimer.h>
#include <tqcolor.h>

#include <netwm.h>

#include <tqdatetime.h>

#include "item.h"
#include "xosd.h"
#include "clip.h"
#include "setupdialogprg.h"
#include "dinfo.h"

const int MAX_ICONS = 150; // max number of icons
const int UPDATE_DIST = 1; // update when x - last_x <= UPDATE_DIST
const int DEF_SMALL_SIZE = 32; // default small icon size
const int DEF_BIG_SIZE = 90; // default big icon size
const int DEF_DOCK_OPACITY = 50; // default dock opacity
const int DEF_PRIORITY = 5; // default priority
const int DEF_HIDDEN = 1; // default hidden priority
const int ANIM_TOTAL_STEP = 6; // not in use yet

const int SPACE_W = 1; // space between quick launchers and tasks (the seperator)

const int ON_CHANGE_ANIM_INTERVAL = 50; // animation's interval

/** KoolDock is the base class of the project */
class KoolDock : public TQWidget
{
   TQ_OBJECT

   public:
   /** construtor */
   KoolDock(TQWidget* parent = 0, const char* name = 0);
   /** destructor */
   ~KoolDock();

   void setMainPath(const TQString& path); // send run paramenters to the widget
   void setArgs(const TQString& param);
   clip *clipw; // clipping window - makes kooldock's edge sticky

   private:
      TQTime* perf; // variable used to control animation speed
      // configuration variables
      int fShowTaskbar; // show-taskbar flag
      int fMinimizedOnly; // show only minimized icons flag
      int fShowNotification; // show-notification flag
      int fShowBorders; // show-borders flag
      int fShowKMenu;	// show the K menu
      int fUseKBFX; // makes kooldock use KBFX insted of K menu
      int fPriority;	// "nice" priority
      int fMouseTimer;	// Mouse timer interval
      int fClipping;	// window area clippig
      int fClipIcons;	// icon area clipping
      long int fzoomSpeed, zoomStep, zoomStepB, zoomStepS, zoomVal;	//speed of show/hide animation
      int zoomTicksB, zoomTicksS; //counts timer ticks
      int neededTicksB,neededTicksS; //sets how many ticks is necessary to calculate new speed
      bool fSpeed; // enables speed control
      TQColor borderColor;
      int fHidden;	// determines dock's autohide
      int fStayBelow; // makes dock stay below other windows while not focused
      int fOrientation;	//bottom/left/top/right
      int fHideOnClick; // determines if kooldock should hide after clicking an icon
      int fSteppy; // enables autocenter on icon
      int fShowFrames;	// frames to show the dock "growing from bottom"
      int fGrowFrames;	// frames to grow the icon when the mouse is over it.
      int fHighLightTime;
      bool fFirstRun; // shows information box one time
      bool fShowShot; // makes kooldock do screenshot of minimized window
      bool fGrouping; // enables window grouping
      int xinerama; //whether we want xinerama
      int hideTimer; //user define time to show dock
      int Solid; //whether using background Image or not (for preference controls)
      int fShowNav; //whether we want the navigation menu (clock + desktop chooser) in kooldocks main menu
      int numSystray; //for systray control
      int fSystray; //whether we want the systray or not
      int fCurrent; //whether to only show windows on current desktop
      int oldDesktop; //number of previous desktop
      bool firstTime; //to control certain things
      TQString curTheme; //for the background theme (to preserve changes)
      int leftRes; //Left monitor resolution
      int XinDesiredHeight; // size of screen on which kooldock is visible in Xinerama
      int XinPreviousWidth;
      int fpercentPos; // sets position of dock on screen

      bool lockSetTab; // disables changing opened tab in preferences window
      bool reloadIcons; // sets the need of reloading icons after changes in setting
      bool initialization; // blocks dock during loading settings
      int ptPart; // variable used in speed control as state data

      bool mouseOnLauncher; // determines if mouse is on laucher icon or on window icon
      TQStringList lstDrop; // list of dropped elements
      bool useList; // determines if dropped elements should be sent to selected application

      Atom net_system_tray_selection;
      Atom net_system_tray_opcode;

      TQString fLeftImg; //paths to background images
      TQString fRightImg;
      TQString fCenterImg;
      bool fNWideBg; // determines if background should not be wider than screen
      bool scaleMax; // sets scaling mode of background corners

      TQPixmap LeftImg;
      TQPixmap RightImg;
      TQPixmap CenterImg;
      TQPixmap TempScaledCenter;

      int iwSmall; // sizes of small and big icon
      int iwBig; // size of current big icon - during animation its value is between iwSmall and iwBig2
      int iwBig2; // size of base size of big icon

      int firstX, tmpw; // variables used in background positioning
      int oldfirstX, oldtmpw;
      int lastX;

      int dockOpacity;
      TQColor bgColor;

      TQColor sepColor; // separator bar's color

      int Ybase; // sets position of dock, and how big part of dock is out of screen

      // normal variables
      TQString progPath;
      TQString menuPath;
      TQString confFile;
      TQString iFilename;  // right clicked item filename
      TQString mainPath;
      TQString args;

      TQStringList ignoreList;

      NETWinInfo* info; // window informations
      KWinModule* wm;
      SetupDialog* setupdlg;

      int Offset; // scrolls dock if all icons are wider than screen
      int numLaunchers; // number of quick launcher items
      int x, y, w, h, h0, h1, w0, x0, w1, x1; // positions *0 - small *1 big
      int rx, ry, rw, rh, uw; //current position
      int ix, iy, iDist, iSpace; // sizes of dock's elements - icons, distance between small icon centres, space between them
      int dw, dh, rdh; // real current position
      int funcW, funcH; // variables used to calculate zoomed icons sizes
      int ii_first, ii_last; // idexes of first and last zoomed icons
      int soffset, eoffset; //used in icon positioning
      int adjust; // offset of first zoomed icon
      int fAmount; // amount of big icons
      int last_mx; // mouse position
      int last_ncx;

      TQPtrList<Item> items;//currently visible items
      TQPtrList<Item> witems;//all windows on all desktops
      int iSize[MAX_ICONS + 1];//icon sizes
      int cx[MAX_ICONS + 1];//positions of small icons
      int cur_cx[MAX_ICONS + 1];//positions of visible icons
      TQPixmap offscr;//drawing buffer

      KRootPixmap* rootpix;
      KPixmap bottomBg;
      KPixmap bottomBgf; // faded bottom background
      TQPixmap topBg;

      TDEAboutDialog* aboutDlg;
      TQTimer* mkbigTimer; //zoom animation timers
      TQTimer* mksmallTimer;
      TQTimer* mTimer; //mouse move emulator (can't use normal event instead)
      TQTimer* onChangeTimer; // used when a window has changed and we need to notify user
      TQTimer* trackTimer; //checks whether mouse touches screen edge

      int animStep; // animation step, not in use yet
      int iOnClick; // index of the quick launcher being clicked
      WId cId;  // id of the application (used in the right click menu over the taskbar)
      WId CurrentFocus; // id of window that is currently active
      TDEPopupMenu *deskpopup; // moving between desktops
      TDEPopupMenu *appMenu;  // list of windows in selected group
      TDEPopupMenu *godesk; // sends window to another desktop
      TDEPopupMenu *tasklist; // list of all windows
      TDEPopupMenu *popup; // main popup
      TDEPopupMenu *advMenu; // kicker like advanced menu of window icon
      int menuCount; // counts menus - disable dock hiding when popups are visible, and determines if user want to do some changes to specific window, or to all windows in group
      int currMenu; // information to which window user apply changes
      bool allApps; // sets if dock should apply changes to all windows
      TQPtrList<TDEPopupMenu> popups;
      bool iGroup; // menu of icon is connect with single window or with group of windows
      int dIndex, nDesks; // index of desktop (0 for all), count of desktops
      TQPtrList<dInfo> desks;

      bool fExpanded; // informs if kooldock is zoomed
      bool track2active; // checks if second tracking timer is active - to make kooldock open in proper time
       /*Xosd Section */
      TQString nom;
      TQString aux;
      int xosd_st;
      int showNames;
      int fCleaner;
      int xosdShadowOffset;
      TQString xosdFont;
      TQString xosdColor;
      TQString xosdShadowColor;
      bool xosdBold;
      bool xosdItalic;
      int xosdSize;
      KURIFilterData* _filterData;
      xosd* xosdw;

      int animValue; // icon highlight
      int animState;

      bool doRepaint;
      int lastXPos; // postion of mouse - used in autocenter
      int lastYPos;

      void run(const TQString& cmd); // runs command, including data dropped of launcher
      int func(int x); // function used in scaling zoomed icons
      int func2(int x);
      void doUpdateGeometry(); // updates kooldock dimentios, and icon positions
      bool addTask(WId id, int iFound=-1); // add window to dock
      bool rmTask(WId id, int iFound=-1); // remove window from dock
      void rmwTask(int iFound); // remove window from list (hidden, used for performance)
      bool addwTask(WId id);
      void movetoback(WId id); // send icon in group to end of list - used to determine order of windows in group
      void loadConf();
      void loadIgnore();
      void saveConf();
      void loadMenu();
      void addWindows(); // refreshes list of windows (hidden list, and icons on dock)
      int itemFromPoint(int x); // gets icon in specified point
      int xFromIndex(int i); // gets position of icon from its index
      void createMenu(TDEPopupMenu* tmpMenu, KWin::WindowInfo* info);
      void updTaskList(); // recreate popup menu of all applications
      void addToTaskList(WId id); // add window to menu
      void rmFromTaskList(WId id); // remove from menu
      void init();

   protected:
      void paintEvent(TQPaintEvent*);
      void mousePressEvent(TQMouseEvent*);
      void mMoveEvent(int ex, int ey); // mouse move event called by timer (to avoid 'freezes' i.e. when menu are open)
      void mPress(int mx, int my, ButtonState srcButton); // press event, used insted of normal event for simplicity of calling
      void wheelEvent(TQWheelEvent*);
      void enterEvent(TQEvent*);
      void onleaveEvent(TQEvent*); // event called when mouse leves dock
      void mksmallTimerstop(); // called when stopping smalling aninamtion
      void dragMoveEvent(TQDragMoveEvent* event);
      void dropEvent(TQDropEvent* event);

   public slots:
      void edit(); // shows launcher editing page
      void editPref(); // shows preferences
      void about();
      void windowAdded(WId id); // events called when window appaers/disappears
      void windowRemoved(WId id);
      void numberOfDesktopsChanged(int); // called when number of desktops has changed
      void windowChanged(WId id, unsigned int properties); // when window was modified - moved, resized, minimized, etc.
      void activeWindowChanged(WId id); // focus changed
      void workAreaChanged();
      void currentDesktopChanged(int);
      void onChangeTimerTicked(); // called when icon is highlighted
      void updateBackground(const TQPixmap&);
      void moveApp(); // functions used to manipulate windows
      void resizeApp();
      void minApp();
      void maxApp();
      void restApp();
      void minAllApps();
      void maxAllApps();
      void restAllApps();
      void closeAllApps();
      void shadeApp();
      void activateApp();
      void closeApp();
      void toggleAlwaysOnTop();
      void toggleKeptBelowOthers();
      void toggleFullScreen();
      void sendToDesktop(int); // sends app to another desktop
      void goToWindow(int); // sets focus
      void editItem(); // edit launcher
      void removeItem(); // remove launcher
      void goToDesktop(int); // changes current desktop

      /* Systray support */
      void systemTrayWindowAdded(WId id);
      void systemTrayWindowRemoved(WId id);

      /* menus */
      void aboutToShow(); // events associated with all popups
      void aboutToHide();

      static void addFile(const TQString& filename,
                          const TQString& iconname,
                          const TQString& execname,
                          const TQString& name,
                          bool notify = true,
                          bool terminal = false,
                          bool tclose = false,
                          bool cuser = false,
                          TQString = "na");
      bool ignored(const TQString& appname);

      #ifdef _ENABLE_DEBUG
      static void debug(TQString message);
      #endif
      #ifndef _ENABLE_DEBUG
      static void debug(TQString);
      #endif
      void mkbigTimerDo(); // tick of animation timers
      void mksmallTimerDo();
      void endProg();
      void mTimerEnd(); // event called by mTimer - detects mouse position
      void trackTimerEnd(); // checks if cursor touched screen edge, on which kooldock is autohided
      void trackTimer2End(); // enabled by first trackTimer - provides kooldock's opening in proper time
      void restart();
      void reload();
      void chkRestart(); // sub called by preferences window, after clicking apply or ok
      void refreshBackground();
      void unhighlight();
      void move2(int nx, int ny); // moves dock
      void resize2(int nw, int nh); // resizes dock
      void getBottomBG(); // gets bottom part of background - covered by small icons
      void getTopBG(); // gets upper part of background - covered by zoomed icons
      void setDesktopIconsArea(int, int, int, int); // changes KDE desktop area
      void setDockAbove();
      void setDockBelow();
      void menuX(int num); // event called when user highlighted menu of specified window in window group menu
      void menuShow(); // event called when deskpopup is about to show - updates settings on menu for selected window
      void pTest(); // performance test
};

#endif // KOOLDOCK_H
