/*
	Copyright (C) 2006 Michael Lentner <michaell@gmx.net>
	
	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License version 2 as published by the Free Software Foundation.
	
	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
	Library General Public License for more details.
	
	You should have received a copy of the GNU General Public License
	along with this library; if not, write to the Free Software
	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
*/


#ifndef _QEMBED_CLIENTDATA
#define _QEMBED_CLIENTDATA
#include <tqimage.h>
#include <tqdict.h>
static const TQRgb client_bottom_lines_dark_data[] = {
    0x18000000,0x18000000,0x18000000,0x18000000,0x18000000,0x18000000,0x18000000,0x18000000,0x18000000,0x18000000,0x44000000,0x44000000,0x44000000,0x44000000,
    0x44000000,0x44000000,0x44000000,0x44000000,0x44000000,0x44000000
};

/* Generated by qembed */
static const TQRgb client_bottomLines_data[] = {
    0x6000000,0x6000000,0x6000000,0x6000000,0x6000000,0x6000000,0x6000000,0x6000000,0x6000000,0x6000000,0x13000000,0x13000000,0x13000000,0x13000000,
    0x13000000,0x13000000,0x13000000,0x13000000,0x13000000,0x13000000
};

static const TQRgb clientButtonContour_data[] = {
    0x0,0x0,0x0,0x0,0x2000000,0x9000000,0xe000000,0xf000000,0xf000000,0xe000000,0x9000000,0x2000000,0x0,0x0,
    0x0,0x0,0x0,0x0,0x1000000,0x7000000,0x27000000,0x8c000000,0xc4000000,0xc9000000,0xc9000000,0xc4000000,0x8c000000,0x27000000,
    0x7000000,0x1000000,0x0,0x0,0x0,0x0,0xa000000,0x64000000,0xca000000,0x6a000000,0x1b000000,0xf000000,0xf000000,0x1b000000,
    0x6a000000,0xca000000,0x64000000,0xa000000,0x1000000,0x0,0x0,0x7000000,0x5f000000,0xb5000000,0x23000000,0x8000000,0x1000000,0x0,
    0x0,0x1000000,0x8000000,0x23000000,0xb5000000,0x5f000000,0x7000000,0x0,0x2000000,0x20000000,0xbd000000,0x1e000000,0x3000000,0x0,
    0x0,0x0,0x0,0x0,0x0,0x3000000,0x1e000000,0xbd000000,0x20000000,0x2000000,0x9000000,0x88000000,0x62000000,0x7000000,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7000000,0x62000000,0x88000000,0x9000000,0xe000000,0xc2000000,
    0x1a000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x1a000000,0xc2000000,0xe000000,
    0xf000000,0xc9000000,0xf000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xf000000,
    0xc9000000,0xf000000,0xf000000,0xc9000000,0xf000000,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0xf000000,0xc9000000,0xf000000,0xe000000,0xc2000000,0x19000000,0x1000000,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x1000000,0x19000000,0xc2000000,0xe000000,0x9000000,0x88000000,0x62000000,0x7000000,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x7000000,0x62000000,0x88000000,0x9000000,0x2000000,0x20000000,0xbd000000,0x1e000000,0x3000000,0x0,
    0x0,0x0,0x0,0x0,0x0,0x3000000,0x1e000000,0xbd000000,0x20000000,0x2000000,0x0,0x7000000,0x5f000000,0xb5000000,
    0x23000000,0x7000000,0x1000000,0x0,0x0,0x1000000,0x7000000,0x23000000,0xb5000000,0x5f000000,0x7000000,0x0,0x0,0x1000000,
    0xa000000,0x64000000,0xca000000,0x6a000000,0x1b000000,0xf000000,0xf000000,0x1b000000,0x6a000000,0xca000000,0x64000000,0xa000000,0x1000000,0x0,
    0x0,0x0,0x1000000,0x7000000,0x27000000,0x8c000000,0xc4000000,0xc9000000,0xc9000000,0xc4000000,0x8c000000,0x27000000,0x7000000,0x1000000,
    0x0,0x0,0x0,0x0,0x0,0x0,0x2000000,0x9000000,0xe000000,0xf000000,0xf000000,0xe000000,0x9000000,0x2000000,
    0x0,0x0,0x0,0x0
};

static const TQRgb clientButtonPressed_data[] = {
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xb151515,0x400b0b0b,0x420d0d0d,0x420d0d0d,0x41090909,0xb151515,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1000000,0x39131313,0x6d010101,0x68000000,0x62000000,0x62000000,0x67000000,
    0x70000000,0x50070707,0x1000000,0x0,0x0,0x0,0x0,0x0,0x1000000,0x5a040404,0x62000000,0x51000000,0x44000000,0x3e000000,
    0x3d000000,0x43000000,0x4e000000,0x5f000000,0x51070707,0x1000000,0x0,0x0,0x0,0x0,0x3d0b0b0b,0x5a000000,0x42000000,0x32000000,
    0x27000000,0x24000000,0x24000000,0x26000000,0x30000000,0x41000000,0x58000000,0x45060606,0x0,0x0,0x0,0x91a1a1a,0x5e000000,0x41000000,
    0x2b000000,0x1e000000,0x18000000,0x16000000,0x15000000,0x18000000,0x1d000000,0x29000000,0x40000000,0x5b000000,0x12000000,0x0,0x0,0x28090909,
    0x4a000000,0x2e000000,0x1b000000,0x14000000,0x11000000,0x10000000,0x10000000,0x10000000,0x13000000,0x1b000000,0x2c000000,0x49000000,0x31040404,0x0,
    0x0,0x33050505,0x3d000000,0x22000000,0x14000000,0xf000000,0xd000000,0xd000000,0xd000000,0xd000000,0xe000000,0x14000000,0x21000000,0x3c000000,
    0x2d070707,0x0,0x0,0x2f040404,0x34000000,0x1b000000,0xf000000,0xb000000,0xa000000,0xa000000,0xa000000,0xa000000,0xb000000,0xf000000,
    0x1b000000,0x34000000,0x2a050505,0x0,0x0,0x2d020202,0x32000000,0x18000000,0xc000000,0x9000000,0x8000000,0x8000000,0x8000000,0x8000000,
    0x9000000,0xd000000,0x19000000,0x33000000,0x28020202,0x0,0x0,0x14000000,0x35000000,0x1a000000,0xc000000,0x7000000,0x6000000,0x6000000,
    0x6000000,0x6000000,0x7000000,0xd000000,0x1b000000,0x37000000,0xf000000,0x0,0x0,0x0,0x2b000000,0x23000000,0x12000000,0xa000000,
    0x7000000,0x6000000,0x6000000,0x7000000,0xa000000,0x13000000,0x24000000,0x29000000,0x0,0x0,0x0,0x0,0x1000000,0x26000000,
    0x1e000000,0x12000000,0xc000000,0xa000000,0xa000000,0xc000000,0x13000000,0x1f000000,0x25000000,0x1000000,0x0,0x0,0x0,0x0,
    0x0,0x2000000,0x23000000,0x23000000,0x1b000000,0x16000000,0x16000000,0x1b000000,0x24000000,0x23000000,0x1000000,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x8000000,0x1c000000,0x19000000,0x19000000,0x1b000000,0x7000000,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0
};

static const TQRgb clientButtonShadow_data[] = {
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x16fdfdfd,0x52fdfdfd,0x6ffdfdfd,0x6ffdfdfd,0x50fdfdfd,0x16fdfdfd,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xafdfdfd,0x7bfcfcfc,0x78fdfdfd,0x65ffffff,0x6ffdfdfd,0x6ffdfdfd,0x65ffffff,
    0x77fdfdfd,0x7afdfdfd,0x9fdfdfd,0x0,0x0,0x0,0x0,0x0,0xcfdfdfd,0x7bfdfdfd,0x69fdfdfd,0x4cfcfcfc,0x40ffffff,0x3bffffff,
    0x3bffffff,0x40ffffff,0x4bffffff,0x69fdfdfd,0x7afcfcfc,0x9fdfdfd,0x0,0x0,0x0,0x3ffffff,0x66fcfcfc,0x58ffffff,0x37fcfcfc,0x2dffffff,
    0x2bffffff,0x2bffffff,0x2bffffff,0x2bffffff,0x2dfbfbfb,0x37ffffff,0x58fcfcfc,0x64fdfdfd,0x3ffffff,0x0,0x0,0x25fdfdfd,0x50f9f9f9,0x32fafafa,
    0x26f8f8f8,0x25f8f8f8,0x25f8f8f8,0x25f8f8f8,0x25f8f8f8,0x25f8f8f8,0x25f8f8f8,0x26f8f8f8,0x31fafafa,0x51f9f9f9,0x20fdfdfd,0x0,0x4bfbfbf,0x69fafafa,
    0x3cf1f1f1,0x22e8e8e8,0x20e7e7e7,0x20e7e7e7,0x20e7e7e7,0x20e7e7e7,0x20e7e7e7,0x20e7e7e7,0x20e7e7e7,0x20e7e7e7,0x22e8e8e8,0x3cf3f3f3,0x66fafafa,0x3ffffff,
    0xcffffff,0x8cfcfcfc,0x2fe5e5e5,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x1acdcdcd,0x2fe5e5e5,
    0x8afbfbfb,0xaffffff,0x12f2f2f2,0x91f8f8f8,0x29d6d6d6,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,0x15aaaaaa,
    0x15aaaaaa,0x28d7d7d7,0x91f8f8f8,0x10f0f0f0,0x12f2f2f2,0x81f8f8f8,0x2acdcdcd,0x11777777,0x106f6f6f,0x106f6f6f,0x106f6f6f,0x106f6f6f,0x106f6f6f,0x106f6f6f,
    0x106f6f6f,0x106f6f6f,0x11777777,0x2bcecece,0x80f8f8f8,0x10f0f0f0,0xcffffff,0x5cf8f8f8,0x31cacaca,0x167f7f7f,0xc151515,0xb000000,0xb000000,0xb000000,
    0xb000000,0xb000000,0xb000000,0xc151515,0x168b8b8b,0x37d5d5d5,0x55f8f8f8,0xbe9e9e9,0x4ffffff,0x32fafafa,0x78f2f2f2,0x24a8a8a8,0x17777777,0xe121212,
    0xd000000,0xd000000,0xd000000,0xd000000,0xe121212,0x17797979,0x25ababab,0x7df3f3f3,0x2bffffff,0x3ffffff,0x0,0x15f3f3f3,0x66fcfcfc,0x64e9e9e9,
    0x29acacac,0x1e858585,0x19707070,0x143f3f3f,0x143f3f3f,0x196e6e6e,0x1e858585,0x2aadadad,0x6debebeb,0x63f9f9f9,0x12ffffff,0x0,0x0,0x3ffffff,
    0x26ffffff,0x7afafafa,0x7ff1f1f1,0x3cc4c4c4,0x30adadad,0x2ba6a6a6,0x2ba4a4a4,0x30afafaf,0x3ec3c3c3,0x84f1f1f1,0x77fafafa,0x22ffffff,0x3ffffff,0x0,
    0x0,0x0,0x5ffffff,0x27f9f9f9,0x52fcfcfc,0x80f9f9f9,0x96f6f6f6,0x85f2f2f2,0x86f2f2f2,0x97f6f6f6,0x81fafafa,0x4ffcfcfc,0x20f8f8f8,0x4ffffff,
    0x0,0x0,0x0,0x0,0x0,0x4bfbfbf,0xeffffff,0x32fafafa,0x3ffcfcfc,0x50fcfcfc,0x4ffcfcfc,0x3ffcfcfc,0x2ffafafa,0xef2f2f2,
    0x3ffffff,0x0,0x0,0x0
};

static const TQRgb client_close_6x6_data[] = {
    0x6c2a2a2a,0x6b2a2a2a,0x0,0x0,0x6b2a2a2a,0x702a2a2a,0x7b2a2a2a,0xd62a2a2a,0x5c2a2a2a,0x792a2a2a,0xd62a2a2a,0x782a2a2a,0x0,0x7b2a2a2a,
    0xd62a2a2a,0xd62a2a2a,0x782a2a2a,0x0,0x0,0x7b2a2a2a,0xd62a2a2a,0xd62a2a2a,0x782a2a2a,0x0,0x7b2a2a2a,0xd62a2a2a,0x782a2a2a,0x5e2a2a2a,
    0xd62a2a2a,0x782a2a2a,0x6c2a2a2a,0x782a2a2a,0x0,0x0,0x5e2a2a2a,0x6c2a2a2a
};

static const TQRgb client_dot_4x4_data[] = {
    0x422a2a2a,0x9b2a2a2a,0x9b2a2a2a,0x422a2a2a,0x9b2a2a2a,0xb02a2a2a,0xb02a2a2a,0x9b2a2a2a,0x9b2a2a2a,0xb02a2a2a,0xb02a2a2a,0x9b2a2a2a,0x422a2a2a,0x9b2a2a2a,
    0x9b2a2a2a,0x422a2a2a
};

static const TQRgb client_edges_dark_data[] = {
    0x0,0x0,0x0,0x34000000,0x35000000,0x35000000,0x34000000,0x0,0x0,0x0,0x0,0x0,0x34000000,0x2b000000,
    0xe000000,0xe000000,0x2b000000,0x34000000,0x0,0x0,0x0,0x39000000,0x23000000,0x10000000,0x3000000,0x3000000,0x10000000,0x23000000,
    0x39000000,0x0,0x3000000,0x38000000,0x11000000,0x3000000,0x0,0x0,0x3000000,0x11000000,0x38000000,0x3000000,0x34000000,0x2a000000,
    0x5000000,0x1000000,0x0,0x0,0x1000000,0x5000000,0x2a000000,0x34000000,0x35000000,0x1e000000,0x3000000,0x0,0x0,0x0,
    0x0,0x3000000,0x1e000000,0x35000000,0x37000000,0x20000000,0x3000000,0x0,0x0,0x0,0x0,0x3000000,0x20000000,0x37000000,
    0x38000000,0x2c000000,0x6000000,0x1000000,0x0,0x0,0x1000000,0x6000000,0x2c000000,0x38000000,0x4000000,0x3d000000,0x13000000,0x3000000,
    0x0,0x0,0x3000000,0x13000000,0x3d000000,0x4000000,0x0,0x40000000,0x28000000,0x13000000,0x4000000,0x4000000,0x13000000,0x28000000,
    0x40000000,0x0,0x0,0x0,0x41000000,0x36000000,0x12000000,0x12000000,0x36000000,0x41000000,0x0,0x0,0x0,0x0,
    0x0,0x41000000,0x44000000,0x44000000,0x41000000,0x0,0x0,0x0
};

static const TQRgb client_edges_data[] = {
    0x0,0x0,0x0,0x2fffffff,0x31ffffff,0x31ffffff,0x2fffffff,0x0,0x0,0x0,0x0,0x0,0x2effffff,0x25ffffff,
    0x11ffffff,0x11ffffff,0x25ffffff,0x2effffff,0x0,0x0,0x0,0x34ffffff,0x1fffffff,0xeffffff,0x3ffffff,0x3ffffff,0xeffffff,0x1fffffff,
    0x34ffffff,0x0,0x2ffffff,0x33ffffff,0xeffffff,0x3ffffff,0x0,0x0,0x3ffffff,0xeffffff,0x33ffffff,0x2ffffff,0x2fffffff,0x1fffffff,
    0x4ffffff,0x1ffffff,0x0,0x0,0x1ffffff,0x4ffffff,0x1fffffff,0x2fffffff,0x2dffffff,0x12ffffff,0x2ffffff,0x0,0x0,0x0,
    0x0,0x2ffffff,0x12ffffff,0x2dffffff,0x27ebebeb,0x18f5f5f5,0x3ffffff,0x0,0x0,0x0,0x0,0x3ffffff,0x18f5f5f5,0x27ebebeb,
    0x28e5e5e5,0x1bcacaca,0x6ffffff,0x1ffffff,0x0,0x0,0x1ffffff,0x6ffffff,0x1bcacaca,0x28e5e5e5,0x1000000,0x1c888888,0xbb9b9b9,0x3ffffff,
    0x0,0x0,0x3ffffff,0xbb9b9b9,0x1c888888,0x1000000,0x0,0x1d838383,0x11696969,0xab2b2b2,0x4ffffff,0x4ffffff,0xab2b2b2,0x11696969,
    0x1d838383,0x0,0x0,0x0,0x12000000,0x15616161,0xcaaaaaa,0xcaaaaaa,0x15616161,0x12000000,0x0,0x0,0x0,0x0,
    0x0,0x12000000,0x13000000,0x13000000,0x12000000,0x0,0x0,0x0
};

static const TQRgb client_help_5x8_data[] = {
    0x22a2a2a,0x772a2a2a,0xc22a2a2a,0xbd2a2a2a,0x302a2a2a,0x3b2a2a2a,0xd22a2a2a,0x612a2a2a,0x862a2a2a,0xbd2a2a2a,0x22a2a2a,0x22a2a2a,0x0,0x5b2a2a2a,
    0xba2a2a2a,0x0,0x0,0x462a2a2a,0xbd2a2a2a,0x3e2a2a2a,0x0,0x0,0xd12a2a2a,0x682a2a2a,0x0,0x0,0x0,0x542a2a2a,
    0x2a2a2a2a,0x0,0x0,0x0,0xb82a2a2a,0x5b2a2a2a,0x0,0x0,0x0,0x262a2a2a,0x82a2a2a,0x0
};

static const TQRgb client_line_6x2_data[] = {
    0x852a2a2a,0xbe2a2a2a,0xbe2a2a2a,0xbe2a2a2a,0xbe2a2a2a,0x852a2a2a,0x432a2a2a,0x5f2a2a2a,0x5f2a2a2a,0x5f2a2a2a,0x5f2a2a2a,0x432a2a2a
};

static const TQRgb client_max_8x8_data[] = {
    0x0,0x0,0x0,0x852a2a2a,0x442a2a2a,0x0,0x0,0x0,0x0,0x0,0x0,0xbe2a2a2a,0x602a2a2a,0x0,
    0x0,0x0,0x12a2a2a,0x12a2a2a,0x0,0xbe2a2a2a,0x602a2a2a,0x0,0x0,0x0,0x852a2a2a,0xbe2a2a2a,0xbe2a2a2a,0xbe2a2a2a,
    0xbe2a2a2a,0xbe2a2a2a,0xbe2a2a2a,0x852a2a2a,0x442a2a2a,0x602a2a2a,0x602a2a2a,0xbe2a2a2a,0x902a2a2a,0x622a2a2a,0x632a2a2a,0x452a2a2a,0x0,0x0,
    0x0,0xbd2a2a2a,0x602a2a2a,0x0,0x0,0x0,0x0,0x0,0x0,0xbd2a2a2a,0x612a2a2a,0x0,0x0,0x0,
    0x0,0x0,0x0,0x852a2a2a,0x442a2a2a,0x0,0x0,0x0
};

static const TQRgb client_right_lines2_data[] = {
    0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,
    0xfffffff,0x24ffffff,0xfffffff,0x24ffffff,0xfffffff,0x24ffffff
};

static const TQRgb client_right_lines_dark_data[] = {
    0x19000000,0x36000000,0x19000000,0x36000000,0x19000000,0x36000000,0x19000000,0x36000000,0x19000000,0x36000000,0x19000000,0x36000000,0x19000000,0x36000000,
    0x19000000,0x36000000,0x19000000,0x36000000,0x19000000,0x36000000
};

static const TQRgb client_topLines2_data[] = {
    0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x39ffffff,0x11ffffff,0x11ffffff,0x11ffffff,0x11ffffff,
    0x11ffffff,0x11ffffff,0x11ffffff,0x11ffffff,0x11ffffff,0x11ffffff
};

static const TQRgb client_top_lines_dark_data[] = {
    0x36000000,0x36000000,0x36000000,0x36000000,0x36000000,0x36000000,0x36000000,0x36000000,0x36000000,0x36000000,0x13000000,0x13000000,0x13000000,0x13000000,
    0x13000000,0x13000000,0x13000000,0x13000000,0x13000000,0x13000000
};

static const TQRgb client_upArrow_6x8_data[] = {
    0x0,0x0,0x492a2a2a,0x142a2a2a,0x0,0x0,0x0,0x4a2a2a2a,0xb92a2a2a,0xa82a2a2a,0x1e2a2a2a,0x0,0x572a2a2a,0xb92a2a2a,
    0xb92a2a2a,0xb82a2a2a,0xac2a2a2a,0x1d2a2a2a,0x0,0x0,0xb92a2a2a,0x5c2a2a2a,0x0,0x0,0x0,0x0,0xb92a2a2a,0x5c2a2a2a,
    0x0,0x0,0x0,0x0,0xb92a2a2a,0x5c2a2a2a,0x0,0x0,0x0,0x0,0xb92a2a2a,0x5c2a2a2a,0x0,0x0,
    0x0,0x0,0x812a2a2a,0x402a2a2a,0x0,0x0
};


static struct EmbedImage {
    int width, height, depth;
    const unsigned char *data;
    int numColors;
    const TQRgb *colorTable;
    bool alpha;
    const char *name;
} embed_image_vec[] = {
	{ 10, 2, 32, (const unsigned char*)client_bottom_lines_dark_data, 0, 0, TRUE, "client_bottomLines_dark" },
	{ 10, 2, 32, (const unsigned char*)client_bottomLines_data, 0, 0, TRUE, "client_bottomLines" },
	{ 16, 16, 32, (const unsigned char*)clientButtonContour_data, 0, 0, TRUE, "clientButtonContour" },
	{ 16, 16, 32, (const unsigned char*)clientButtonPressed_data, 0, 0, TRUE, "clientButtonPressed" },
	{ 16, 16, 32, (const unsigned char*)clientButtonShadow_data, 0, 0, TRUE, "clientButtonShadow" },
	{ 6, 6, 32, (const unsigned char*)client_close_6x6_data, 0, 0, TRUE, "closeButtonIcon" },
	{ 4, 4, 32, (const unsigned char*)client_dot_4x4_data, 0, 0, TRUE, "onAllDesktopsButtonIcon" },
	{ 10, 12, 32, (const unsigned char*)client_edges_dark_data, 0, 0, TRUE, "client_edges_dark" },
	{ 10, 12, 32, (const unsigned char*)client_edges_data, 0, 0, TRUE, "client_edges" },
	{ 5, 8, 32, (const unsigned char*)client_help_5x8_data, 0, 0, TRUE, "helpButtonIcon" },
	{ 6, 2, 32, (const unsigned char*)client_line_6x2_data, 0, 0, TRUE, "minButtonIcon" },
	{ 8, 8, 32, (const unsigned char*)client_max_8x8_data, 0, 0, TRUE, "maxButtonIcon" },
	{ 2, 10, 32, (const unsigned char*)client_right_lines2_data, 0, 0, TRUE, "client_rightLines" },
	{ 2, 10, 32, (const unsigned char*)client_right_lines_dark_data, 0, 0, TRUE, "client_rightLines_dark" },
	{ 10, 2, 32, (const unsigned char*)client_topLines2_data, 0, 0, TRUE, "client_topLines" },
	{ 10, 2, 32, (const unsigned char*)client_top_lines_dark_data, 0, 0, TRUE, "client_topLines_dark" },
	{ 6, 8, 32, (const unsigned char*)client_upArrow_6x8_data, 0, 0, TRUE, "aboveButtonIcon" },
	{ 0, 0, 0, 0, 0, 0, 0, 0 }
};

static const TQImage& qembed_findImage( const TQString& name )
{
    static TQDict<TQImage> dict;
    TQImage* img = dict.find( name );
    if ( !img ) {
	for ( int i = 0; embed_image_vec[i].data; i++ ) {
	    if ( strcmp(embed_image_vec[i].name, name.latin1()) == 0 ) {
		img = new TQImage((uchar*)embed_image_vec[i].data,
			    embed_image_vec[i].width,
			    embed_image_vec[i].height,
			    embed_image_vec[i].depth,
			    (TQRgb*)embed_image_vec[i].colorTable,
			    embed_image_vec[i].numColors,
			    TQImage::BigEndian );
		if ( embed_image_vec[i].alpha )
		    img->setAlphaBuffer( TRUE );
		dict.insert( name, img );
		break;
	    }
	}
	if ( !img ) {
	    static TQImage dummy;
	    return dummy;
	}
    }
    return *img;
}

#endif
