/***************************************************************************
                          smalldialogs.cpp  -  description
                             -------------------
    begin                : Son Jul 20 2003
    copyright            : (C) 2003 by Dominik Seichter
    email                : domseichter@web.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "smalldialogs.h"
#include "sqltables.h"

// TQt includes
#include <tqlabel.h>
#include <tqlayout.h>
#include <tqsqlcursor.h>

// KDE includes
#include <knuminput.h>
#include <klineedit.h>
#include <tdelocale.h>


using namespace DSSmallDialogs;

AddAllDialog::AddAllDialog(TQWidget *parent, const char *name )
    : KDialogBase( KDialogBase::Plain, i18n("Add Barcode_basic"),
      KDialogBase::Ok | KDialogBase::Cancel, KDialogBase::Ok, parent,name)
{
    TQVBoxLayout* layout = new TQVBoxLayout( plainPage(), 6, 6 );

    group = new KLineEdit( plainPage() );
    number = new KIntNumInput( plainPage() );
    number->setLabel( i18n( "Number of labels:" ) );
    number->setRange( 1, 10000, 1, false );

    layout->addWidget( new TQLabel( i18n("Group:"), plainPage() ) );
    layout->addWidget( group );
    layout->addWidget( number );
}

TQString AddAllDialog::groupName() const
{
    return group->text();
}

int AddAllDialog::numberLabels() const
{
    return number->value();
}

AddItemsDialog::AddItemsDialog(TQWidget *parent, const char *name )
    : KDialogBase( KDialogBase::Plain, i18n("Add Items"),
      KDialogBase::User1 | KDialogBase::Close, KDialogBase::User1, parent,name)
{
    init();
}

AddItemsDialog::AddItemsDialog( const TQString & a, const TQString & g, int c, TQWidget* parent, const char* name )
    : KDialogBase( KDialogBase::Plain, i18n("Edit Item"),
      KDialogBase::Ok| KDialogBase::Close, KDialogBase::Ok, parent,name)
{
    init();
    article->setText( a );
    group->setText( g );
    number->setValue( c );
}

void AddItemsDialog::init()
{
    plainPage()->setFrameStyle( TQFrame::GroupBoxPanel | TQFrame::Sunken );
    plainPage()->setLineWidth( 2 );

    TQHBoxLayout* layout = new TQHBoxLayout( plainPage(), 6, 6 );

    group = new KLineEdit( plainPage() );
    article = new KLineEdit( plainPage() );

    number = new KIntNumInput( plainPage() );
    number->setLabel( i18n( "Number of labels:" ), KNumInput::AlignLeft | KNumInput::AlignVCenter );
    number->setRange( 1, 10000, 1, false );

    layout->addWidget( number );
    layout->addWidget( new TQLabel( i18n("Article:" ), plainPage() ) );
    layout->addWidget( article );
    layout->addWidget( new TQLabel( i18n("Group:"), plainPage() ) );
    layout->addWidget( group );

    setButtonText( KDialogBase::User1, i18n("&Add") );

    setupSql();

    connect( SqlTables::getInstance(), TQT_SIGNAL( tablesChanged() ), this, TQT_SLOT( setupSql() ) );
    connect( SqlTables::getInstance(), TQT_SIGNAL( connectedSQL() ), this, TQT_SLOT( setupSql() ) );
}

void AddItemsDialog::slotUser1()
{
    emit add( article->text(), group->text(), number->value() );

    number->setValue( 1 );
    article->setText( "" );
    group->setText( "" );
    article->setFocus();
}

void AddItemsDialog::setupSql()
{
    SqlTables* tables = SqlTables::getInstance();
    if( !tables->isConnected() )
        return;

    TDECompletion* comp = article->completionObject();
    comp->clear();
    TQSqlQuery query( "select article_no from " TABLE_BASIC " order by article_no" );
    TQStringList slist;
    while ( query.next() )
        slist.append( query.value(0).toString() );

    comp->setItems( slist );
}

void AddItemsDialog::setGroupCompletion( TDECompletion* c )
{
    group->setCompletionObject( c );
}

int AddItemsDialog::count() const
{
    return number->value();
}

const TQString AddItemsDialog::articleNo() const
{
    return article->text();
}

const TQString AddItemsDialog::groupName() const
{
    return group->text();
}

#include "smalldialogs.moc"
