/***************************************************************************
                          knowitedit.cpp  -  description
                             -------------------
    begin                : pi maj 23 2003
    copyright            : (C) 2003 by Micha Rudolf
    email                : mrudolf@kdewebdev.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knowitedit.h"
#include <kurldrag.h>

KnowitEdit::KnowitEdit(const TQString& text, const TQString& context, TQWidget* parent,
   const char* name) : KTextEdit(text, context, parent, name), swapEOL(true)
{
   setAcceptDrops(true);
}

      
KnowitEdit::KnowitEdit(TQWidget* parent, const char* name) : KTextEdit(parent, name),
   swapEOL(true)
{

}

void KnowitEdit::keyPressEvent(TQKeyEvent* e)
{
   if (swapEOL &&
          (e->key() == TQt::Key_Enter || e->key() == TQt::Key_Return) &&
          (e->state() | (Qt::NoButton |  TQt::ControlButton | TQt::Keypad) ==
             (Qt::NoButton |  TQt::ControlButton | TQt::Keypad))) {
      TQKeyEvent* e1 = new TQKeyEvent(TQKeyEvent::KeyPress, e->key(),
         e->ascii(), e->state() ^ TQt::ControlButton, e->text(), e->isAutoRepeat(),
         e->count());
      e->ignore();
      TQTextEdit::keyPressEvent(e1);      
      }
   else TQTextEdit::keyPressEvent(e);
}

void KnowitEdit::contentsDragEnterEvent(TQDragEnterEvent* event)
{
   if (KURLDrag::canDecode(event))
      event->accept(true);
   else TQTextEdit::contentsDragEnterEvent(event);
}

void KnowitEdit::contentsDropEvent(TQDropEvent* event)
{
   if (KURLDrag::canDecode(event)) {
      KURL::List L;
      KURLDrag::decode(event, L);
      for (uint i=0; i<L.count(); i++)
         emit textDropped(L[i].url(), L.count() > 1);
   }
   else TQTextEdit::contentsDropEvent(event);
}

#include "knowitedit.moc"
