/***************************************************************************
 * testwindow.cpp
 * This file is part of the KDE project
 * copyright (C)2004-2005 by Sebastian Sauer (mail@dipe.org)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 * You should have received a copy of the GNU Library General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 ***************************************************************************/

#include "testwindow.h"
#include "testplugin.h"

#include <tqlabel.h>
#include <tqvbox.h>
#include <tqvgroupbox.h>
//#include <tqhgroupbox.h>
#include <tqcombobox.h>
#include <tqdir.h>
#include <tqpopupmenu.h>

#include <ktextedit.h>
#include <kpushbutton.h>
#include <tdepopupmenu.h>
#include <tdemenubar.h>
#include <kstandarddirs.h>

TestWindow::TestWindow(const TQString& interpretername, const TQString& scriptcode)
    : TDEMainWindow()
    , m_interpretername(interpretername)
    , m_scriptcode(scriptcode)
{
    Kross::Api::Manager* manager = Kross::Api::Manager::scriptManager();
    manager->addModule( new TestPluginModule("krosstestpluginmodule") );
    m_scriptcontainer = manager->getScriptContainer("test");

    TDEPopupMenu *menuFile = new TDEPopupMenu( this );
    menuBar()->insertItem( "&File", menuFile );

    m_scriptextension = new Kross::Api::ScriptGUIClient(this, this);

    TQString file = TDEGlobal::dirs()->findResource("appdata", "testscripting.rc");
    if(file.isNull())
        file = TQDir(TQDir::currentDirPath()).filePath("testscripting.rc");
    else Kross::krossdebug("-------------------------222222");

    Kross::krossdebug(TQString("XML-file: %1").arg(file));
    m_scriptextension->setXMLFile(file);

    //menuFile->insertSeparator();

    TDEAction* execaction = m_scriptextension->action("executescriptfile");
    if(execaction) execaction->plug(menuFile);

    TDEAction* configaction = m_scriptextension->action("configurescripts");
    if(configaction) configaction->plug(menuFile);

    TDEAction* scriptsaction = m_scriptextension->action("installedscripts");
    if(scriptsaction) scriptsaction->plug(menuFile);
    //menuFile->insertItem( ( (TDEActionMenu*)m_scriptextension->action("scripts") )->popupMenu() );

    TQVBox* mainbox = new TQVBox(this);

    TQVGroupBox* interpretergrpbox = new TQVGroupBox("Interpreter", mainbox);
    TQStringList interpreters = Kross::Api::Manager::scriptManager()->getInterpreters();
    m_interpretercombo = new TQComboBox(interpretergrpbox);
    m_interpretercombo->insertStringList(interpreters);
    m_interpretercombo->setCurrentText(interpretername);

    TQVGroupBox* scriptgrpbox = new TQVGroupBox("Scripting code", mainbox);
    m_codeedit = new KTextEdit(m_scriptcode, TQString(), scriptgrpbox);
    m_codeedit->setWordWrap(TQTextEdit::NoWrap);
    m_codeedit->setTextFormat(TQt::PlainText);

    TQHBox* btnbox = new TQHBox(mainbox);
    KPushButton* execbtn = new KPushButton("Execute", btnbox);
    connect(execbtn, TQT_SIGNAL(clicked()), this, TQT_SLOT(execute()));

    setCentralWidget(mainbox);
    setMinimumSize(600,420);
}

TestWindow::~TestWindow()
{
}

void TestWindow::execute()
{
    m_scriptcontainer->setInterpreterName( m_interpretercombo->currentText() );
    m_scriptcontainer->setCode(m_codeedit->text());
    Kross::Api::Object::Ptr result = m_scriptcontainer->execute();
    if(m_scriptcontainer->hadException()) {
        Kross::krossdebug( TQString("EXCEPTION => %1").arg(m_scriptcontainer->getException()->toString()) );
    }
    else {
        TQString s = result ? result->toString() : TQString();
        Kross::krossdebug( TQString("DONE => %1").arg(s) );
    }
}

#include "testwindow.moc"
