#!/usr/bin/env python

"""
  This Python script demonstrates the usage of the Kross
  python-interface to access KexiDB functionality from
  within Python.
"""

class TkTest:
	def __init__(self):
		import tkinter
		self.root = tkinter.Tk()
		self.root.title("TkTest")
		self.root.deiconify()

		self.mainframe = tkinter.Frame(self.root)
		self.mainframe.pack()

		self.button1 = tkinter.Button(self.mainframe, text="Button1", command=self.callback1)
		self.button1.pack(side=tkinter.LEFT)

		self.button2 = tkinter.Button(self.mainframe, text="Button2", command=self.callback2)
		self.button2.pack(side=tkinter.LEFT)

		self.exitbutton = tkinter.Button(self.mainframe, text="Exit", command=self.root.destroy)
		self.exitbutton.pack(side=tkinter.LEFT)

		self.root.mainloop()

	def callback1(self):
		import tkinter.messagebox
		tkinter.messagebox.showinfo("Callback1", "Callback1 called.")

	def callback2(self):
		import tkinter.messagebox
		tkinter.messagebox.showinfo("Callback2", "Callback2 called.")

class TQtTest:
	def __init__(self):
		from TQt import tqt

		class Button(tqt.TQPushButton):
			def __init__(self, *args):
				tqt.TQPushButton.__init__(*(self,) + args)

		class ComboBox(tqt.TQHBox):
 			def __init__(self, parent, caption, items = []):
				tqt.TQHBox.__init__(self, parent)
				self.setSpacing(6)
				label = tqt.TQLabel(str(caption), self)
				self.combobox = tqt.TQComboBox(self)
				self.setStretchFactor(self.combobox, 1)
				label.setBuddy(self.combobox)
				for item in items:
					self.combobox.insertItem( str(item) )

		class FileChooser(tqt.TQHBox):
			def __init__(self, *args):
				tqt.TQHBox.__init__(*(self,) + args)
				self.defaultfilename = "~/output.html"

				self.setSpacing(6)
				label = tqt.TQLabel("File:", self)
				self.edit = tqt.TQLineEdit(self)
				self.edit.setText(self.defaultfilename)
				self.setStretchFactor(self.edit, 1)
				label.setBuddy(self.edit)

				browsebutton = Button("...", self)
				tqt.TQObject.connect(browsebutton, tqt.SIGNAL("clicked()"), self.browseButtonClicked)

			def file(self):
				return self.edit.text()

			def browseButtonClicked(self):
				filename = None
				try:
					# try to use the tdefile module included in pytde
					import tdefile
					filename = tdefile.KFileDialog.getOpenFileName(self.defaultfilename, "*.html", self, "Save to file")
				except:
					# fallback to TQt filedialog
					filename = tqt.TQFileDialog.getOpenFileName(self.defaultfilename, "*.html", self, "Save to file")
				if filename != None and filename != "":
					self.edit.setText(filename)

		class Dialog(tqt.TQDialog):
			def __init__(self, parent = None, name = None, modal = 0, fl = 0):
				tqt.TQDialog.__init__(self, parent, name, modal, fl)
				tqt.TQDialog.accept = self.accept
				self.setCaption("Export to HTML")
				#self.layout()

				self.layout = tqt.TQVBoxLayout(self)
				self.layout.setSpacing(6)
				self.layout.setMargin(11)

				infolabel = tqt.TQLabel("Export the data of a table or a query to a HTML-file.", self)
				self.layout.addWidget(infolabel)

				source = ComboBox(self, "Datasource:")
				self.layout.addWidget(source)

				self.exporttype = ComboBox(self, "Style:", ["Plain","Paper","Desert","Blues"])
				self.layout.addWidget(self.exporttype)

				self.filechooser = FileChooser(self)
				self.layout.addWidget(self.filechooser)

				buttonbox = tqt.TQHBox(self)
				buttonbox.setSpacing(6)
				self.layout.addWidget(buttonbox)

				savebutton = Button("Save", buttonbox)
				tqt.TQObject.connect(savebutton, tqt.SIGNAL("clicked()"), self, tqt.SLOT("accept()"))
				#tqt.TQObject.connect(savebutton, tqt.SIGNAL("clicked()"), self.exportButtonClicked)

				cancelbutton = Button("Cancel", buttonbox)
				tqt.TQObject.connect(cancelbutton, tqt.SIGNAL("clicked()"), self, tqt.SLOT("close()"))

			def accept(self):
				print("ACCEPTTTTTTTT !!!!!!!!!!!!!!!!!!!!!!!!!!!!")

				file = tqt.TQFile( self.filechooser.file() )
				#if not file.exists():
				#	print "File '%s' does not exist." % self.filechooser.file()
				#else:
				#	print "File '%s' does exist." % self.filechooser.file()

			def exportButtonClicked(self):
				print("Export to HTML !!!!!!!!!!!!!!!!!!!!!!!!!!!!")

			def __getattr__(self, attr):
				print("=> Dialog.__getattr__(self,attr)")
			#def closeEvent(self, ev): pass
			def event(self, e):
				print("=> Dialog.event %s" % e)
				#self.deleteLater()
				#support.swapThreadState() # calls appropriate c-function
				return tqt.TQDialog.event(self, e)

		app = tqt.tqApp
		dialog = Dialog(app.mainWidget(), "Dialog", 1)
		dialog.show()

print("################## BEGIN")
#TkTest()
TQtTest()
print("################## END")
